﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.h>

typedef nnt::vi::util::Fixture ListDisplays;

TEST_F(ListDisplays, DefaultOnly_Any)
{
    nn::vi::Initialize();

    nn::vi::DisplayInfo displays[16];
    std::memset(displays, 0, sizeof(displays));

    // More displays might be added, but need to be careful about ordering
    ASSERT_LE(1, nn::vi::ListDisplays(displays, sizeof(displays) / sizeof(displays[0])));

    EXPECT_STREQ("Default", displays[0].name);
    EXPECT_TRUE(displays[0].hasLayerLimit);
    EXPECT_EQ(1, displays[0].layerCountMax);
    EXPECT_EQ(1920, displays[0].layerWidthPixelCountMax);
    EXPECT_EQ(1080, displays[0].layerHeightPixelCountMax);
}
