﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture SetDisplayRgbRange;

TEST_F(SetDisplayRgbRange, Default_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::RgbRange ranges[nn::vi::RgbRange_Max];
    int rangeCount = nn::vi::ListDisplayRgbRanges(ranges, sizeof(ranges) / sizeof(ranges[0]), pDisplay);
    ASSERT_NE(0, rangeCount);

    nn::vi::RgbRange current;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayRgbRange(&current, pDisplay));

    for( int i = 0; i < rangeCount; ++i )
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::SetDisplayRgbRange(pDisplay, ranges[i]));

        nn::vi::RgbRange range;
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayRgbRange(&range, pDisplay));

        switch( range )
        {
        case nn::vi::RgbRange_Limited:
            break;
        case nn::vi::RgbRange_Full:
            break;
        default:
            FAIL();
        }

        EXPECT_EQ(ranges[i], range);
    }

    NNT_ASSERT_RESULT_SUCCESS(nn::vi::SetDisplayRgbRange(pDisplay, current));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayRgbRange, External_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    nn::vi::RgbRange ranges[nn::vi::RgbRange_Max];
    int rangeCount = nn::vi::ListDisplayRgbRanges(ranges, sizeof(ranges) / sizeof(ranges[0]), pDisplay);
    ASSERT_NE(0, rangeCount);

    nn::vi::RgbRange current;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayRgbRange(&current, pDisplay));

    for( int i = 0; i < rangeCount; ++i )
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::SetDisplayRgbRange(pDisplay, ranges[i]));

        nn::vi::RgbRange range;
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayRgbRange(&range, pDisplay));

        switch( range )
        {
        case nn::vi::RgbRange_Limited:
            break;
        case nn::vi::RgbRange_Full:
            break;
        default:
            FAIL();
        }

        EXPECT_EQ(ranges[i], range);
    }

    NNT_ASSERT_RESULT_SUCCESS(nn::vi::SetDisplayRgbRange(pDisplay, current));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayRgbRange, Edid_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Edid"));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::SetDisplayRgbRange(pDisplay, nn::vi::RgbRange_Auto));

    nn::vi::CloseDisplay(pDisplay);
}

TEST(SetDisplayRgbRangePreconditions, ViNotInitialized_Any)
{
    nn::vi::Display* pDisplay = reinterpret_cast<nn::vi::Display*>(0x1234);
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::SetDisplayRgbRange(pDisplay, nn::vi::RgbRange_Auto), "");
}

TEST(SetDisplayRgbRangePreconditions, pDisplayNull_Any)
{
    nn::vi::Initialize();

    EXPECT_DEATH_IF_SUPPORTED(nn::vi::SetDisplayRgbRange(nullptr, nn::vi::RgbRange_Auto), "");

    nn::vi::Finalize();
}

TEST(SetDisplayRgbRangePreconditions, pDisplayInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::CloseDisplay(pDisplay);

        EXPECT_DEATH_IF_SUPPORTED(nn::vi::SetDisplayRgbRange(pDisplay, nn::vi::RgbRange_Auto), "");
    }

    nn::vi::Finalize();
}
