﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.h>

typedef nnt::vi::util::Fixture OpenDisplay;

TEST_F(OpenDisplay, NotFound_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotFound, nn::vi::OpenDisplay(&pDisplay, ""));
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotFound, nn::vi::OpenDisplay(&pDisplay, "wat"));
}

TEST_F(OpenDisplay, Default_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Default"));
    EXPECT_NE(nullptr, pDisplay);

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(OpenDisplay, DoubleOpen_Default_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Default"));
    EXPECT_NE(nullptr, pDisplay);

    nn::vi::Display* pDupe;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDupe, "Default"));
    EXPECT_NE(nullptr, pDupe);

    nn::vi::CloseDisplay(pDisplay);
    nn::vi::CloseDisplay(pDisplay);
}

TEST(OpenDisplayPreconditions, ViNotInitialized_Any)
{
    nn::vi::Display* pDisplay;
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::OpenDisplay(&pDisplay, "Default"), "");
}

TEST(OpenDisplayPreconditions, pOutDisplayNull_Any)
{
    nn::vi::Initialize();
    EXPECT_DEATH_IF_SUPPORTED(nn::vi::OpenDisplay(nullptr, "Default"), "");
    nn::vi::Finalize();
}

TEST(OpenDisplayPreconditions, NameNull_Any)
{
    nn::vi::Initialize();
    nn::vi::Display* pDisplay;
    EXPECT_DEATH_IF_SUPPORTED(nn::vi::OpenDisplay(&pDisplay, nullptr), "");
    nn::vi::Finalize();
}
