﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/vi.h>

TEST(CloseDisplayPreconditions, ViNotInitialized_Any)
{
    // need some non-null value to avoid other preconditions
    nn::vi::Display* pDisplay = reinterpret_cast<nn::vi::Display*>(0x1234);
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::CloseDisplay(pDisplay), "");
}

TEST(CloseDisplayPreconditions, pDisplayNull_Any)
{
    nn::vi::Initialize();

    EXPECT_DEATH_IF_SUPPORTED(nn::vi::CloseDisplay(nullptr), "");

    nn::vi::Finalize();
}

TEST(CloseDisplayPreconditions, pDisplayInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));
    nn::vi::CloseDisplay(pDisplay);

    EXPECT_DEATH_IF_SUPPORTED(nn::vi::CloseDisplay(pDisplay), "");

    nn::vi::Finalize();
}
