﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <list>
#include <memory>

#include <nn/nn_Common.h>

#include "IPanelPreparationTask.h"

namespace panel{

    class PanelPreparationTaskQueue
    {
    public:
        bool IsEmpty() const NN_NOEXCEPT;
        int GetCount() const NN_NOEXCEPT;

        // キューの末尾にタスクを積む
        void Enqueue(const std::shared_ptr<IPanelPreparationTask>& pTask) NN_NOEXCEPT;
        void Enqueue(std::shared_ptr<IPanelPreparationTask>&& pTask) NN_NOEXCEPT;

        // キューの先頭のタスクを取得する。キューからは削除される。
        // タスクが積まれていなければ nullptr を返す。
        std::shared_ptr<IPanelPreparationTask> Dequeue() NN_NOEXCEPT;

        // キューの先頭にタスクを戻す。 pTask が nullptr の場合は何もしない。
        void Cancel(const std::shared_ptr<IPanelPreparationTask>& pTask) NN_NOEXCEPT;
        void Cancel(std::shared_ptr<IPanelPreparationTask>&& pTask) NN_NOEXCEPT;

    private:
        std::list<std::shared_ptr<IPanelPreparationTask>> m_Queue;
    };

}
