﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "PanelPreparationTaskQueue.h"

namespace panel{

    bool PanelPreparationTaskQueue::IsEmpty() const NN_NOEXCEPT
    {
        return m_Queue.empty();
    }

    int PanelPreparationTaskQueue::GetCount() const NN_NOEXCEPT
    {
        return static_cast<int>(m_Queue.size());
    }

    void PanelPreparationTaskQueue::Enqueue(const std::shared_ptr<IPanelPreparationTask>& pTask) NN_NOEXCEPT
    {
        m_Queue.push_back(pTask);
    }

    void PanelPreparationTaskQueue::Enqueue(std::shared_ptr<IPanelPreparationTask>&& pTask) NN_NOEXCEPT
    {
        m_Queue.push_back(std::move(pTask));
    }

    std::shared_ptr<IPanelPreparationTask> PanelPreparationTaskQueue::Dequeue() NN_NOEXCEPT
    {
        if(m_Queue.empty())
        {
            return nullptr;
        }

        auto p = std::move(m_Queue.front());
        m_Queue.pop_front();

        return p;
    }

    void PanelPreparationTaskQueue::Cancel(const std::shared_ptr<IPanelPreparationTask>& pTask) NN_NOEXCEPT
    {
        if(pTask == nullptr)
        {
            return;
        }

        m_Queue.push_front(pTask);
    }

    void PanelPreparationTaskQueue::Cancel(std::shared_ptr<IPanelPreparationTask>&& pTask) NN_NOEXCEPT
    {
        if(pTask == nullptr)
        {
            return;
        }

        m_Queue.push_front(std::move(pTask));
    }

}
