﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nnt.h>

#include "testVi_Context.h"
#include "testVi_Macro.h"

static const int DefaultLoopCount = 100;

NNT_VI_TEST_SERVERSTATE(Loop_SLCreate_SLDestroy)
{
    const int LoopCount = DefaultLoopCount;
    NN_LOG("SLCreate>SLDestroy-------------------------------\n");
    Context context;

    context.ConnectService();
    for(int i = 0; i < LoopCount; i++)
    {
        nn::vi::fbshare::SharedLayerHandle hSharedLayer = {};
        NN_LOG("LOOP %d/%d\n", i + 1, LoopCount);
        NN_ABORT_UNLESS_RESULT_SUCCESS(context.CreateSharedLayer(&hSharedLayer, nn::applet::GetAppletResourceUserId()));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context.DestroySharedLayer(hSharedLayer));
    }
    context.DisconnectService();
}

NNT_VI_TEST_SERVERSTATE(ShimInit_SLCreate_ShimExit)
{
    const int LoopCount = DefaultLoopCount;
    NN_LOG("SLCreate>SLDestroy-------------------------------\n");
    Context context;

    for(int i = 0; i < LoopCount; i++)
    {
        nn::vi::fbshare::SharedLayerHandle hSharedLayer = {};
        NN_LOG("LOOP %d/%d\n", i + 1, LoopCount);
        context.ConnectService();
        NN_ABORT_UNLESS_RESULT_SUCCESS(context.CreateSharedLayer(&hSharedLayer, nn::applet::GetAppletResourceUserId()));
        //NN_ABORT_UNLESS_RESULT_SUCCESS(context.DestroySharedLayer(hSharedLayer));
        context.DisconnectService();
    }
}

//-------------------------------------------------------------------------------

NNT_VI_TEST_SERVERSTATE(Loop_SLOpen1_SLClose1)
{
    const int LoopCount = DefaultLoopCount;
    NN_LOG("SLOpen1>SLClose1-------------------------------\n");
    Context context0({"server"});
    Context context1({"client"});

    nn::vi::fbshare::SharedLayerHandle hSharedLayer = {};
    context0.ConnectService();
    context1.ConnectService();
    NN_ABORT_UNLESS_RESULT_SUCCESS(context0.CreateSharedLayer(&hSharedLayer, nn::applet::GetAppletResourceUserId()));

    for(int i = 0; i < LoopCount; i++)
    {
        NN_LOG("LOOP %d/%d\n", i + 1, LoopCount);
        NN_ABORT_UNLESS_RESULT_SUCCESS(context1.OpenSharedLayer(hSharedLayer));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context1.CloseSharedLayer(hSharedLayer));
    }

    context1.DisconnectService();
    context0.DisconnectService();
}

NNT_VI_TEST_SERVERSTATE(Loop_SLCreate0_SLOpen1_SLDestroy0)
{
    const int LoopCount = DefaultLoopCount;
    NN_LOG("SLCreate0>SLOpen1>SLDestroy0-------------------------------\n");
    Context context0({"server"});
    Context context1({"client"});

    context0.ConnectService();
    context1.ConnectService();

    for(int i = 0; i < LoopCount; i++)
    {
        nn::vi::fbshare::SharedLayerHandle hSharedLayer = {};
        NN_LOG("LOOP %d/%d\n", i + 1, LoopCount);
        NN_ABORT_UNLESS_RESULT_SUCCESS(context0.CreateSharedLayer(&hSharedLayer, nn::applet::GetAppletResourceUserId()));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context1.OpenSharedLayer(hSharedLayer));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context0.DestroySharedLayer(hSharedLayer));
        NNT_VI_EXPECT_ERROR(nn::vi::ResultNotFound, context1.CloseSharedLayer(hSharedLayer));
    }

    context1.DisconnectService();
    context0.DisconnectService();
}

NNT_VI_TEST_SERVERSTATE(Loop_ShimInit1_SLOpen1_ShimExit1)
{
    const int LoopCount = DefaultLoopCount;
    NN_LOG("SLCreate0>SLOpen1>ShimExit1-------------------------------\n");
    Context context0({"server"});
    Context context1({"client"});

    context0.ConnectService();

    nn::vi::fbshare::SharedLayerHandle hSharedLayer = {};
    NN_ABORT_UNLESS_RESULT_SUCCESS(context0.CreateSharedLayer(&hSharedLayer, nn::applet::GetAppletResourceUserId()));

    for(int i = 0; i < LoopCount; i++)
    {
        NN_LOG("LOOP %d/%d\n", i + 1, LoopCount);
        context1.ConnectService();
        NN_ABORT_UNLESS_RESULT_SUCCESS(context1.OpenSharedLayer(hSharedLayer));
        context1.DisconnectService();
    }

    context0.DisconnectService();
}

//-------------------------------------------------------------------------------

NNT_VI_TEST_SERVERSTATE(Loop_SLConnect1_SLDisconnect1)
{
    const int LoopCount = DefaultLoopCount;
    NN_LOG("SLConnect1>SLDisconnect1-------------------------------\n");
    Context context0({"server"});
    Context context1({"client"});

    nn::vi::fbshare::SharedLayerHandle hSharedLayer = {};
    context0.ConnectService();
    context1.ConnectService();
    NN_ABORT_UNLESS_RESULT_SUCCESS(context0.CreateSharedLayer(&hSharedLayer, nn::applet::GetAppletResourceUserId()));
    NN_ABORT_UNLESS_RESULT_SUCCESS(context1.OpenSharedLayer(hSharedLayer));

    for(int i = 0; i < LoopCount; i++)
    {
        NN_LOG("LOOP %d/%d\n", i + 1, LoopCount);
        NN_ABORT_UNLESS_RESULT_SUCCESS(context1.ConnectSharedLayer(hSharedLayer));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context1.DisconnectSharedLayer(hSharedLayer));
    }

    context1.DisconnectService();
    context0.DisconnectService();

}

NNT_VI_TEST_SERVERSTATE(Loop_SLOpen1_SLConnect1_SLClose1)
{
    const int LoopCount = DefaultLoopCount;
    NN_LOG("SLOpen1>SLConnect1>SLClose1-------------------------------\n");
    Context context0({"server"});
    Context context1({"client"});

    nn::vi::fbshare::SharedLayerHandle hSharedLayer = {};
    context0.ConnectService();
    context1.ConnectService();
    NN_ABORT_UNLESS_RESULT_SUCCESS(context0.CreateSharedLayer(&hSharedLayer, nn::applet::GetAppletResourceUserId()));

    for(int i = 0; i < LoopCount; i++)
    {
        NN_LOG("LOOP %d/%d\n", i + 1, LoopCount);
        NN_ABORT_UNLESS_RESULT_SUCCESS(context1.OpenSharedLayer(hSharedLayer));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context1.ConnectSharedLayer(hSharedLayer));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context1.CloseSharedLayer(hSharedLayer));
        NNT_VI_EXPECT_ERROR(nn::vi::ResultNotFound, context1.DisconnectSharedLayer(hSharedLayer));
    }

    context1.DisconnectService();
    context0.DisconnectService();
}

NNT_VI_TEST_SERVERSTATE(Loop_SLCreate0_SLOpen1_SLConnect1_SLDestroy0)
{
    const int LoopCount = DefaultLoopCount;
    NN_LOG("SLCreate0>SLOpen1>SLConnect1>SLDestroy0-------------------------------\n");
    Context context0({"server"});
    Context context1({"client"});

    context0.ConnectService();
    context1.ConnectService();

    for(int i = 0; i < LoopCount; i++)
    {
        nn::vi::fbshare::SharedLayerHandle hSharedLayer = {};
        NN_LOG("LOOP %d/%d\n", i + 1, LoopCount);
        NN_ABORT_UNLESS_RESULT_SUCCESS(context0.CreateSharedLayer(&hSharedLayer, nn::applet::GetAppletResourceUserId()));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context1.OpenSharedLayer(hSharedLayer));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context1.ConnectSharedLayer(hSharedLayer));
        NN_ABORT_UNLESS_RESULT_SUCCESS(context0.DestroySharedLayer(hSharedLayer));
        NNT_VI_EXPECT_ERROR(nn::vi::ResultNotFound, context1.DisconnectSharedLayer(hSharedLayer));
        NNT_VI_EXPECT_ERROR(nn::vi::ResultNotFound, context1.CloseSharedLayer(hSharedLayer));
    }

    context1.DisconnectService();
    context0.DisconnectService();
}
