﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/nn_Log.h>

#include <nn/vi.h>
#include <nn/vi.private.h>
#include <nn/vi/vi_DisplayEvents.h>

#include <nnt.h>
#include "testVi_MemoryManagement.h"

void* GraphicsAllocate(size_t size, size_t alignment, void*)
{
    //NN_LOG("gr alloc\n");
    return aligned_alloc(alignment, size);
}
void GraphicsFree(void* p, void*)
{
    //NN_LOG("gr free\n");
    free(p);
}
void* GraphicsReallocate(void* p, size_t size, void*)
{
    //NN_LOG("gr realloc\n");
    return realloc(p, size);
}

TEST(testVi, Display)
{
    nnt::vi::SetupMemory();
    NN_LOG("Initializing nn::vi\n");
    nn::vi::Initialize();

    NN_LOG("ListDisplays\n");
    {
        static const int CountMax = 10;
        nn::vi::DisplayInfo infos[CountMax];
        int nDisp = nn::vi::ListDisplays(infos, CountMax);
        NN_LOG("  found %d displays\n", nDisp);
        for(int i = 0; i < nDisp; i++)
        {
            NN_LOG("    %s\n", infos[i].name);
        }
    }

    NN_LOG("OpenDefaultDisplay\n");
    nn::vi::Display* pDisplay;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        nn::vi::OpenDefaultDisplay(&pDisplay)
    );

    int width;
    int height;
    NN_LOG("GetDisplayResolution\n");
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(
            nn::vi::GetDisplayResolution(&width, &height, pDisplay)
        );
        NN_LOG("    width  : %d\n", width);
        NN_LOG("    height : %d\n", height);
    }

#ifdef NNT_VI_AS_SYSTEM
    {
        NN_LOG("GetZOrderCountMin/Max\n");
        int minValue = nn::vi::GetZOrderCountMin(pDisplay);
        int maxValue = nn::vi::GetZOrderCountMax(pDisplay);
        NN_LOG("    min : %d / max : %d\n", minValue, maxValue);
    }
#endif

    NN_LOG("GetDisplayHotplugState\n");
    {
        nn::vi::HotplugState state = {};
        NN_ABORT_UNLESS_RESULT_SUCCESS(
            nn::vi::GetDisplayHotplugState(&state, pDisplay)
        );
        NN_LOG("  value = %d\n", static_cast<int>(state));
    }

    NN_LOG("CreateLayer\n");
    nn::vi::Layer* pLayer = nullptr;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        nn::vi::CreateLayer(&pLayer, pDisplay)
    );


    //NN_LOG("DestroyLayer\n");
    //nn::vi::DestroyLayer(pLayer);

    NN_LOG("CloseDisplay\n");
    nn::vi::CloseDisplay(pDisplay);

    NN_LOG("Finalizing nn::vi\n");
    nn::vi::Finalize();

    SUCCEED();
}
