﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/system/hid_Nfc.h>
#include <nn/xcd/xcd.h>
#include "NpadController.h"

namespace
{

char g_NpadControllerStorage[sizeof(nnt::xcd::NpadController<nnt::xcd::NpadRightJoy>)];

}  // anonymous

namespace nnt { namespace xcd {

INpadController* CreateNpadController(const nn::hid::NpadIdType& npadId) NN_NOEXCEPT
{
    // 接続されたデバイスに応じたコントローラクラスを作成
    auto style = nn::hid::GetNpadStyleSet(npadId);
    if (style.Test<nn::hid::NpadStyleJoyRight>())
    {
        return new(g_NpadControllerStorage)
            nnt::xcd::NpadController<nnt::xcd::NpadRightJoy>(npadId);
    }
    else if (style.Test<nn::hid::NpadStyleFullKey>())
    {
        return new(g_NpadControllerStorage)
            nnt::xcd::NpadController<nnt::xcd::NpadFullKey>(npadId);
    }
    else if (style.Test<nn::hid::NpadStyleHandheld>())
    {
        return new(g_NpadControllerStorage)
            nnt::xcd::NpadController<nnt::xcd::NpadHandheld>(npadId);
    }
    else
    {
        NN_ABORT("Unsupported style");
    }

    return nullptr;
}

}}  // nnt::xcd
