﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/xcd/xcd.h>
#pragma warning(push)
#pragma warning(disable: 4668)
#include <opencv2/opencv.hpp>
#pragma warning(pop)
#include "ProcessorTaskBase.h"

//============================================================
class MomentModeTestTask : public ProcessorTaskBase
{
public:
    MomentModeTestTask(const char* name, uptr arg)  // arg is unused. you can set NULL when you call the constructor.
    : ProcessorTaskBase(name, arg),
    m_State(),
    m_Config(),
    m_CurrentConfig()
    {
    }

    virtual ~MomentModeTestTask()
    {}

public:
    enum
    {
        MENU_ITEM_MOMENT_WOI,
        MENU_ITEM_MOMENT_PREPROCESS,
        MENU_ITEM_MOMENT_THRESHOLD,
        MENU_ITEM_MOMENT_NUM
    };

    enum Preprocess
    {
        MOMENT_PREPROCESS_CUTOFF,
        MOMENT_PREPROCESS_BINARIZE,
        MOMENT_PREPROCESS_NUM
    };

    struct MomentConfig
    {
        nn::xcd::IrRect woi;
        Preprocess preProcess;
        int threshold;
    };

    static const char* MENU_ITEM_MOMENT_NAMES[MENU_ITEM_MOMENT_NUM];

private:
    void DrawMoment( nn::xcd::IrMomentProcessorState& momentProcessorState, IplImage* pResultImage);
    void SetDefaultMomentConfig(MomentModeTestTask::MomentConfig& config);
    void SaveData(IplImage* pImage, nn::xcd::IrMomentProcessorState& state);
    void CalculateMomentArea(nn::xcd::IrMomentProcessorState& momentProcessorState, nn::xcd::IrMomentStatistic* pStatistic);

protected: // you have to implement
    virtual void DoInitializeCore();
    virtual void DoFinalizeCore();
    virtual void DoCalcCore(IplImage* pImage, IplImage* pDstImage);
    virtual void DoDrawCore(IplImage* pImage);
    virtual void DoDrawMenuCore(IplImage* pImage);
    virtual void DoCalcMenuCore(int* pMenuCnt);
    virtual void DoWriteRegSettingCore(nn::xcd::IrWriteRegisterSetting& setting, int& index);
    virtual void DoSetDefaultConfigCore(ProcessorConfig& config);
    virtual void DoCreateLogFileCore();
    virtual void DoCloseLogFileCore();

private:
    nn::xcd::IrMomentProcessorState m_State;
    MomentConfig m_Config;
    MomentConfig m_CurrentConfig;
}; //MomentModeTestTask

//============================================================
