﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/xcd/xcd.h>
#pragma warning(push)
#pragma warning(disable: 4668)
#include <opencv2/opencv.hpp>
#pragma warning(pop)
#include "ProcessorTaskBase.h"

//============================================================
class ImageTransferModeTestTask : public ProcessorTaskBase
{
public:
    ImageTransferModeTestTask(const char* name, uptr arg)  // arg is unused. you can set NULL when you call the constructor.
    : ProcessorTaskBase(name, arg),
    m_State(),
    m_IsDataUpdated(false),
    m_Config(SIZE_FORMAT_320x240),
    m_CurrentConfig(SIZE_FORMAT_320x240),
    m_DistortionCompensationConfig(DISTORTION_COMPENSATION_CONFIG_NONE),
    m_CurrentDistortionCompensationConfig(DISTORTION_COMPENSATION_CONFIG_NONE),
    m_pDistortionCompensatedImage(nullptr)
    {
    }

    virtual ~ImageTransferModeTestTask()
    {}

public:
    enum SizeFormat
    {
        SIZE_FORMAT_320x240,
        SIZE_FORMAT_160x120,
        SIZE_FORMAT_80x60,
        SIZE_FORMAT_MAX_NUM,
    };

    enum DistortionCompensationConfig
    {
        DISTORTION_COMPENSATION_CONFIG_NONE,
        DISTORTION_COMPENSATION_CONFIG_IDEAL,
        DISTORTION_COMPENSATION_CONFIG_OPTIMIZED,
        DISTORTION_COMPENSATION_CONFIG_MAX_NUM,
    };

    enum
    {
        MENU_ITEM_IMAGE_TRANSFER_SIZE_FORMAT,
        MENU_ITEM_IMAGE_TRANSFER_DISTORTION_COMPENSATION,
        MENU_ITEM_IMAGE_TRANSFER_NUM
    };

    static const char* MENU_ITEM_IMAGE_TRANSFER_NAMES[MENU_ITEM_IMAGE_TRANSFER_NUM];

    struct ImageSize
    {
        int width;
        int height;
    };

    static const ImageSize ImageTransferModeTestTask::FORMAT_SIZE[SIZE_FORMAT_MAX_NUM];
    static const ImageSize ImageTransferModeTestTask::FORMAT_SIZE_UNDISTORTED[SIZE_FORMAT_MAX_NUM];

private:
    void SetDefaultImageTransferConfig(SizeFormat& config);
    void SaveImage(IplImage* pImage);
    void CompensateDistortion(IplImage* pImage, IplImage* pDstImage);

protected: // you have to implement
    virtual void DoInitializeCore();
    virtual void DoFinalizeCore();
    virtual void DoCalcCore(IplImage* pImage, IplImage* pDstImage);
    virtual void DoDrawCore(IplImage* pImage);
    virtual void DoDrawMenuCore(IplImage* pImage);
    virtual void DoCalcMenuCore(int* pMenuCnt);
    virtual void DoWriteRegSettingCore(nn::xcd::IrWriteRegisterSetting& setting, int& index);
    virtual void DoSetDefaultConfigCore(ProcessorConfig& config);
    virtual void DoCreateLogFileCore();
    virtual void DoCloseLogFileCore();

private:
    nn::xcd::IrImageTransferProcessorState m_State;
    bool m_IsDataUpdated;
    SizeFormat m_Config;
    SizeFormat m_CurrentConfig;
    DistortionCompensationConfig m_DistortionCompensationConfig;
    DistortionCompensationConfig m_CurrentDistortionCompensationConfig;
    IplImage* m_pDistortionCompensatedImage;
}; //ImageTransferModeTestTask

//============================================================
