﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "test_Common.h"

namespace test {

//==========================================================
// TimeSpan クラス
//==========================================================

//==========================================================
inline TimeSpan::TimeSpan()
: m_Span(0)
{} //TimeSpan::TimeSpan()

//==========================================================
inline TimeSpan::~TimeSpan()
{} //TimeSpan::~TimeSpan()

//==========================================================
inline void TimeSpan::SetTicks(s64 tick)
{
    m_Span = tick;
} //TimeSpan::SetTick()

//==========================================================
inline void TimeSpan::SetMicroSeconds(s64 usec)
{
    m_Span = usec * sc_Frequency / 1000 / 1000;
} //TimeSpan::SetMicroSeconds()

//==========================================================
inline s64 TimeSpan::GetMicroSeconds() const
{
    return (m_Span * 1000 * 1000 / sc_Frequency);
} //TimeSpan::GetMicroSeconds()

//==========================================================
inline s64 TimeSpan::GetMilliSeconds() const
{
    return (m_Span * 1000 / sc_Frequency);
} //TimeSpan::GetMilliSeconds()

//==========================================================
inline s64 TimeSpan::GetSeconds() const
{
    return (m_Span / sc_Frequency);
} //TimeSpan::GetSeconds()

//==========================================================
inline TimeSpan TimeSpan::operator+(const TimeSpan& rhs) const
{
    TimeSpan time;
    time.m_Span = m_Span + rhs.m_Span;
    return time;
} //TimeSpan::operator+()

//==========================================================
inline TimeSpan TimeSpan::operator-(const TimeSpan& rhs) const
{
    TimeSpan time;
    time.m_Span = m_Span - rhs.m_Span;
    return time;
} //TimeSpan::operator-()

//==========================================================
inline TimeSpan TimeSpan::operator*(const s64 n) const
{
    TimeSpan time;
    time.m_Span = m_Span * n;
    return time;
} //TimeSpan::operator/()

//==========================================================
inline TimeSpan TimeSpan::operator/(const s64 n) const
{
    TimeSpan time;
    time.m_Span = m_Span / n;
    return time;
} //TimeSpan::operator/()

//==========================================================
inline TimeSpan& TimeSpan::operator+=(const TimeSpan& rhs)
{
    m_Span += rhs.m_Span;
    return (*this);
} //TimeSpan::operator+=()

//==========================================================
inline TimeSpan& TimeSpan::operator-=(const TimeSpan& rhs)
{
    m_Span -= rhs.m_Span;
    return (*this);
} //TimeSpan::operator-=()

//==========================================================
inline TimeSpan& TimeSpan::operator*=(const s64 n)
{
    m_Span *= n;
    return (*this);
} //TimeSpan::operator*=()

//==========================================================
inline TimeSpan& TimeSpan::operator/=(const s64 n)
{
    m_Span /= n;
    return (*this);
} //TimeSpan::operator*=()

//==========================================================
// TickTime クラス
//==========================================================

//==========================================================
inline TickTime::TickTime()
: m_Tick(0)
{} //TickTime::TickTime()

//==========================================================
inline TickTime::~TickTime()
{} //TickTime::~TickTime()

//==========================================================
inline TimeSpan TickTime::ToTimeSpan() const
{
    TimeSpan span;
    span.SetTicks(m_Tick);
    return span;
} //TickTime::ToTimeSpan()

//==========================================================
inline TickTime TickTime::operator+(const TimeSpan& rhs) const
{
    TickTime time;
    time.m_Tick = m_Tick + rhs.GetNanoSeconds();
    return time;
} //TickTime::operator+()

//==========================================================
inline TickTime TickTime::operator-(const TickTime& rhs) const
{
    TickTime time;
    time.m_Tick = m_Tick - rhs.m_Tick;
    return time;
} //TickTime::operator-

//==========================================================

} //namespace test
