﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_FrameworkBase.h"
#include "test_TaskBase.h"

namespace test {

//============================================================
FrameworkBase::FrameworkBase()
: m_State(STATE_NOT_INITIALIZED)
, m_pTask(NULL)
{
} //FrameworkBase::FrameworkBase()

//============================================================
FrameworkBase::~FrameworkBase()
{
} //FrameworkBase::~FrameworkBase()

//============================================================
void FrameworkBase::Initialize()
{
    DoInitialize();

    m_State = STATE_INITIALIZED;
    TEST_PRINTF("test : FrameworkBase is Initialized\n");
} //FrameworkBase::Initialize()

//============================================================
void FrameworkBase::Finalize()
{
    DoFinalize();

    m_State = STATE_NOT_INITIALIZED;
    TEST_PRINTF("test : FrameworkBase is Finalized\n");
} //FrameworkBase::Finalize()

//============================================================
void FrameworkBase::Run(TaskBase* pTask)
{
    TEST_ASSERT(m_State == STATE_INITIALIZED);

    // タスクの準備
    {
        // まだ TaskMgr がないので、ControllerMgr もここで初期化。
        m_pTask = pTask;
        m_pTask->Initialize(this);
        m_State = STATE_PREPARED;  // これ以降、サブクラスでタスクにアクセスできる。
    }

    // メインループ実行。Task の Calc, Draw はメインループの中で行なうこと。
    m_State = STATE_RUNNING;
    DoMainLoop();
    m_State = STATE_PREPARED;

    {
        m_pTask->Finalize();
        m_pTask = NULL;
    }
    m_State = STATE_INITIALIZED;
} //FrameworkBase::Run()

//============================================================

} //namespace test
