﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/util/util_StringUtil.h>
#include <nn/fs.h>
#include <nn/os.h>

#include <cctype>
#include <cstring>

#include "TA_common.h"
#include "TA_arg.h"

namespace TestAgent {

using namespace std;

Arg::Arg()
{
    m_Argc = 0;
    m_ModeId = MODE_ID_MANUAL;
}

Arg::~Arg()
{}

void Arg::Initialize()
{
    m_Argc = nn::os::GetHostArgc();
    char** argv = nn::os::GetHostArgv();

    for(int i=0; i<m_Argc; ++i)
    {
        nn::util::Strlcpy(m_Argv[i], argv[i], Arg::ARG_STRING_LENGTH_MAX);
    }
}

void Arg::Initialize(int argc, char argv[ARG_SIZE_MAX][ARG_STRING_LENGTH_MAX])
{
    m_Argc = argc;
    for(int i=0; i<m_Argc; ++i)
    {
        nn::util::Strlcpy(m_Argv[i], argv[i], Arg::ARG_STRING_LENGTH_MAX);
    }
}

bool Arg::Parse()
{
    bool error = false;

    if(m_Argc == 0)
    {
        return false;
    }

    for(int i=1; i<m_Argc && !error; ++i)
    {
        if(std::strcmp(m_Argv[i], "--mode") == 0 || std::strcmp(m_Argv[i], "-m") == 0)
        {
            ++i;
            if(m_Argc > i)
            {
                const int size = 16;
                char modeName[size];
                if(std::strlen(m_Argv[i]) > size)
                {
                    NN_LOG("failed : Too long mode name\n");
                    NN_LOG("       : %s\n", m_Argv[i]);
                    error = true;
                    break;
                }

                nn::util::Strlcpy(modeName, m_Argv[i], size);
                ToUpper(modeName, std::strlen(modeName));
                if (std::strcmp("AGENT", modeName) == 0) {
                    m_ModeId = MODE_ID_TEST_AGENT;
                }

            }
            else
            {
                error = false;
            }
        }
        else
        {
            NN_LOG("Unknow option : %s\n", m_Argv[i]);
            error = true;
        }
    }

    return !error;
}
}
