﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../../Common/testWlan_localApiClass.h"

#include <nn/bsdsocket/cfg/cfg_Types.h>
#include <nn/bsdsocket/cfg/cfg_ClientApi.h>
#include <nn/init.h>

#include <nn/nifm/nifm_ApiIpAddress.h>
#include <nn/nifm.h>
#include <nn/nifm/nifm_ApiForMenu.h>
#include <nn/nifm/nifm_Api.h>
#include <nn/nifm/nifm_ApiWirelessCommunicationControl.h>

#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>
#include <vector>

#include "../../Common/testWlan_UnitTest.h"
#include "../../Common/testWlan_UnitTestCommon.h"


namespace WlanTest {

    TestMasterClientInfo TestMasterClient[nn::wlan::ConnectableClientsCountMax + 1];

    struct TestScanParams
    {
        size_t size;
        nn::wlan::Ssid compareSsid;
        nn::wlan::ScanParameters params;
    };

    struct LocalTestIeInfo
    {
        nn::wlan::ManagementFrameType frameType;
        uint8_t vendrId[256];
        size_t vendrLength;
    };

    struct TestScanActionFrame
    {
        uint8_t buffer[1360];
        size_t bufferSize = sizeof(TestScanActionFrame::buffer);
    };

    struct TestScanConnectParam
    {
        uint32_t maxPool;
        uint32_t readPos;
        uint32_t writePos;
        uint32_t rxId;
        int32_t recvInterval;
        std::unique_ptr<TestScanActionFrame[]> actInfo;
        WlanTest::LocalAutoEvent recvEvent;
        bool isStop;
    };

    // TCP SERVER設定
#define WLAN_INTERFACE_NAME "wl0"

    const int kLocalConcurrencyLimit = 4;

    const uint16_t  PortNo = 5001;
    const int32_t echo_server_backlog = 5;

    const uint32_t ClientMaxConnect = nn::wlan::ConnectableClientsCountMax;

    // StartScanテストパラメータ構造体
    const size_t TestScanMaxSize = 100 * 1024;
    const uint32_t TestBufferMaxPool = 100;

    // PLR基準値
    const float TestUnicastPlrPerRate = 10.00;
    const float TestBroadcastPlrPerRate = 10.00;
    const int TestPlrPaketLostCount = 4;

    // RTT基準値
    const int TestRttPlrRate = 70;

    // Time定義
    const int64_t Time1msec     = 1;
    const int64_t Time10msec    = Time1msec * 10;
    const int64_t Time20msec    = Time10msec * 2;
    const int64_t Time100msec   = Time20msec * 5;
    const int64_t Time300msec   = Time100msec * 3;
    const int64_t Time1s        = Time100msec * 10;
    const int64_t Time3s        = Time300msec * 10;
    const int64_t Time5s        = Time1s * 5;
    const int64_t Time10s       = Time5s * 2;
    const int64_t Time15s       = Time3s * 5;
    const int64_t Time30s       = Time10s * 3;
    const int64_t Time60s       = Time15s * 4;
    const int64_t Time120s      = Time30s * 4;
    const int64_t Time180s      = Time60s * 3;
    const int64_t Time240s      = Time120s * 2;
    const int64_t Time300s      = Time240s + Time60s;
    const int64_t Time600s      = Time300s * 2;
    const int64_t Time1800s     = Time180s * 10;
    const int64_t Time1h        = Time600s * 60;
    const int64_t Time4h        = Time1800s * 8;
    const int64_t Time6h        = Time1h * 6;
    const int64_t Time8h        = Time4h * 2;
    const int64_t Time12h       = Time6h * 2;
    const int64_t Time1day      = Time8h * 3;
    const int64_t PutInterval   = 22;
    const int64_t Interval_1m   = 1;
    const int64_t Interval_5m   = Interval_1m * 5;
    const int64_t Interval_16m  = Interval_5m * 3 + Interval_1m;
    const int64_t Interval_30m  = Interval_5m * 6;
    const int64_t Interval_33m  = Interval_30m + 3;
    const int64_t Interval_100m = 100;

    struct StressTestParameter
    {
        std::vector<int64_t> agingList;
        int32_t agingPos;
        int32_t clientCount;
        int32_t ipOct4;
        std::string ip2g;
        std::string ip5g;
        std::string ssid2g;
        std::string ssid5g;
        nn::nifm::Security etherSecurity2g;
        nn::nifm::Security wifiSecurity2g;
        nn::nifm::Security etherSecurity5g;
        nn::nifm::Security wifiSecurity5g;
    };

    struct ScanTestPattern
    {
        uint32_t scanSize;
        nn::wlan::ScanParameters scanParam;
    };

    struct TestBufferMngRetail
    {
        size_t bufferSize;
        size_t dataSize;
        uint8_t* pData;
        GetTestFrameType frameType;
    };

    struct TestBufferMng
    {
        uint32_t maxCount;
        uint32_t writeIdx;
        uint32_t readIdx;
        TestBufferMngRetail info[TestBufferMaxPool];
        uint8_t* pBuffer;
        size_t bufferSize;
        size_t packetSize;
    };

    enum TestParsePacketEvent
    {
        EventType_Parse = 0,
        EventType_End
    };

    enum TestScanResultType
    {
        Type_ScanPass = 0,
        Type_ScanApiFail,
        Type_ScanActionFrameFail,
        Type_ConnectPass,
        Type_ConnectFail,
        Type_End
    };

#ifdef STATIC_IP
#define STATIC_GW_ADDR          "192.168.11.1"
#define STATIC_IP_ADDR          "192.168.11.25"
#define STATIC_CLIENT1_IP_ADDR  "192.168.11.80"
#define STATIC_CLIENT2_IP_ADDR  "192.168.11.81"
#define STATIC_SUBNET_MASK      "255.255.255.0"
#define STATIC_DNS_1            "8.8.8.8"
#define STATIC_DNS_2            "8.8.8.9"
#endif

    void TraceState(nn::wlan::WlanState oldState, nn::wlan::WlanState newState) NN_NOEXCEPT;
    void TraceState(LocalApiClass* plocal) NN_NOEXCEPT;

    int64_t GetAgintTime() NN_NOEXCEPT;
    int32_t GetClientsCount() NN_NOEXCEPT;
    int32_t GetOct4IpAddress() NN_NOEXCEPT;

    std::string GetIpAddress2g() NN_NOEXCEPT;
    std::string GetIpAddress5g() NN_NOEXCEPT;

    std::string GetSsid2g() NN_NOEXCEPT;
    std::string GetSsid5g() NN_NOEXCEPT;

    nn::nifm::Security* GetEtherSecurity2g() NN_NOEXCEPT;
    nn::nifm::Security* GetEtherSecurity5g() NN_NOEXCEPT;

    nn::nifm::Security* GetWifiSecurity2g() NN_NOEXCEPT;
    nn::nifm::Security* GetWifiSecurity5g() NN_NOEXCEPT;

    const char* GetSubnetMaskString() NN_NOEXCEPT;

};  // namespace WlanTest

