﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>

#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/TargetConfigs/build_Base.h>

#include <nn/wlan/wlan_Types.h>
#include <bwl.h>
#include <dhd_horizon.h>

#include <nn/pcie/pcie.h>
#include <nn/mbuf/mbuf_Mbuf.h>

#include "DhdInit.h"
#include "wlan_MemoryInit.h"


const nn::TimeSpan PadValueSwitchTime = nn::TimeSpan::FromMilliSeconds(5); // gpio (tentative)
static void* sg_InterfaceHandle;
static bool g_ExitThread;

NN_ALIGNAS(4096) char  g_ThreadStack[ 4096 ];
nn::os::ThreadType  g_DhdThread;

#if 0
#include <nn/gpio/gpio.h>
/* gpio (tentative) ------------------------------------------------ */
void InitializeGpioOutput(nn::gpio::GpioPadName pad) NN_NOEXCEPT
{
    nn::gpio::GpioPadSession session;
    nn::gpio::Initialize();
    nn::gpio::OpenSession(&session, pad);
    nn::gpio::SetDirection(&session, nn::gpio::Direction_Output);
    nn::gpio::SetValue(&session, nn::gpio::GpioValue_High);
    nn::os::SleepThread(PadValueSwitchTime);
    nn::gpio::CloseSession(&session);
    nn::gpio::Finalize();
}
#endif

int EventCallBackFromDriver(void* event, void* buf) NN_NOEXCEPT
{
    if(buf != NULL)
    {
        nn::mbuf::Mbuf *pMbuf = reinterpret_cast<nn::mbuf::Mbuf *>(buf);
        nn::mbuf::MbufFreem(pMbuf);
    }
    return 0;
}

int RxCallBackFromDriver(void *buf) NN_NOEXCEPT
{
    if(buf != NULL)
    {
        nn::mbuf::Mbuf *pMbuf = reinterpret_cast<nn::mbuf::Mbuf *>(buf);
        nn::mbuf::MbufFreem(pMbuf);
    }
    return 0;
}

int TxCompletionCallBackFromDriver(void *buf, int result) NN_NOEXCEPT
{
    if(buf != NULL)
    {
        nn::mbuf::Mbuf *pMbuf = reinterpret_cast<nn::mbuf::Mbuf *>(buf);
        nn::mbuf::MbufFreem(pMbuf);
    }
    return 0;
}

void DhdFunc(void* arg)
{
    NN_LOG("Start %s\n", __FUNCTION__);
    int32_t bwl_ret;

    bwl_ret = bwl_dhd_initialize(&sg_InterfaceHandle);
    NN_ABORT_UNLESS(bwl_ret == BWL_ERR_SUCCESS, "bwl command failure");

    bwl_ret = dhd_register_rxdata_cb(sg_InterfaceHandle,
                                    RxCallBackFromDriver);
    NN_ABORT_UNLESS(bwl_ret == BWL_ERR_SUCCESS, "bwl command failure");
    bwl_ret = dhd_register_event_cb(sg_InterfaceHandle,
                                    EventCallBackFromDriver);
    NN_ABORT_UNLESS(bwl_ret == BWL_ERR_SUCCESS, "bwl command failure");
    bwl_ret = dhd_register_txcompletion_cb(sg_InterfaceHandle,
                                    TxCompletionCallBackFromDriver);
    NN_ABORT_UNLESS(bwl_ret == BWL_ERR_SUCCESS, "bwl command failure");

    while( !g_ExitThread )
    {
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(30));
    }
}

/* WLANプロセスの初期化処理 ------------------------------------------------ */
void * InitializeWlan() NN_NOEXCEPT
{
    nn::wlan::InitializeMbuf();

    int32_t bwl_ret;
    bwl_ret = bwl_dhd_initialize(&sg_InterfaceHandle);
    NN_ABORT_UNLESS(bwl_ret == BWL_ERR_SUCCESS, "bwl command failure");

    bwl_ret = dhd_register_rxdata_cb(sg_InterfaceHandle,
                                    RxCallBackFromDriver);
    NN_ABORT_UNLESS(bwl_ret == BWL_ERR_SUCCESS, "bwl command failure");
    bwl_ret = dhd_register_event_cb(sg_InterfaceHandle,
                                    EventCallBackFromDriver);
    NN_ABORT_UNLESS(bwl_ret == BWL_ERR_SUCCESS, "bwl command failure");
    bwl_ret = dhd_register_txcompletion_cb(sg_InterfaceHandle,
                                    TxCompletionCallBackFromDriver);
    NN_ABORT_UNLESS(bwl_ret == BWL_ERR_SUCCESS, "bwl command failure");

    return sg_InterfaceHandle;
}

/* WLANプロセスの終了処理 -------------------------------------------------- */
void FinalizeWlan() NN_NOEXCEPT
{
    g_ExitThread = true;
    nn::os::WaitThread(&g_DhdThread);
    nn::os::DestroyThread(&g_DhdThread);

    bwl_dhd_deinitialize(sg_InterfaceHandle);

    nn::wlan::FinalizeMbuf();
    nn::wlan::FinalizeMemory();
}
