﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/util/util_FormatString.h>

#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>
#include <nn/nifm.h>
#include <nn/nifm/nifm_ApiCommunicationControlForTest.h>

#include <nn/wlan/wlan_Types.h>
#include <nn/wlan/wlan_Ssid.h>
#include <nn/wlan/wlan_InfraApi.h>
#include <nn/wlan/wlan_LocalApi.h>
#include <nn/wlan/wlan_SocketApi.h>
#include <nn/wlan/wlan_ScanResultReader.h>
#include <nn/wlan/wlan_BssDescriptionReader.h>
#include <nn/wlan/wlan_Result.h>

namespace WlanTest {


static const char* wlanConnectionStateStr[] = {
        "IDLE",
        "CONNECTED",
        "DISCONNECTED",
        "JOINED",
};

static const char* cipherTypeString[] =
{
    "USE_GROUPKEY",
    "WEP_40BIT",
    "TKIP",
    "AES_OCB",
    "AES_CCMP",
    "WEP_104BIT",
    "NONE"
};

static const char*  akmTypeString[] =
{
    "NO_WPA",
    "WPA_EAP",
    "WPA_PSK"
};

void ElapsedTime(char* pOutTimeStr, nn::os::Tick srcTick, int64_t tickFreq) NN_NOEXCEPT;
void SystemInitialize() NN_NOEXCEPT;
void SystemFinalize() NN_NOEXCEPT;
void DumpScanResultWithReader(void* pBuf) NN_NOEXCEPT;
void PrintConnectionStatus(nn::wlan::ConnectionStatus* pStatus) NN_NOEXCEPT;
void PrintClientStatus(nn::wlan::ClientStatus* pStatus) NN_NOEXCEPT;
}  // namespace WlanTest
