﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_Country.h>

#include <nn/nn_Log.h>

#include <nnt/nntest.h>

#define SUCCESS_TEST_CASES \
    {"AD", nn::util::Country_Ad}, /* AD, 20, Andorra */ \
    {"AE", nn::util::Country_Ae}, /* AE, 784, United Arab Emirates (the) */ \
    {"AF", nn::util::Country_Af}, /* AF, 4, Afghanistan */ \
    {"AG", nn::util::Country_Ag}, /* AG, 28, Antigua and Barbuda */ \
    {"AI", nn::util::Country_Ai}, /* AI, 660, Anguilla */ \
    {"AL", nn::util::Country_Al}, /* AL, 8, Albania */ \
    {"AM", nn::util::Country_Am}, /* AM, 51, Armenia */ \
    {"AO", nn::util::Country_Ao}, /* AO, 24, Angola */ \
    {"AQ", nn::util::Country_Aq}, /* AQ, 10, Antarctica */ \
    {"AR", nn::util::Country_Ar}, /* AR, 32, Argentina */ \
    {"AS", nn::util::Country_As}, /* AS, 16, American Samoa */ \
    {"AT", nn::util::Country_At}, /* AT, 40, Austria */ \
    {"AU", nn::util::Country_Au}, /* AU, 36, Australia */ \
    {"AW", nn::util::Country_Aw}, /* AW, 533, Aruba */ \
    {"AX", nn::util::Country_Ax}, /* AX, 248, Åland Islands */ \
    {"AZ", nn::util::Country_Az}, /* AZ, 31, Azerbaijan */ \
    {"BA", nn::util::Country_Ba}, /* BA, 70, Bosnia and Herzegovina */ \
    {"BB", nn::util::Country_Bb}, /* BB, 52, Barbados */ \
    {"BD", nn::util::Country_Bd}, /* BD, 50, Bangladesh */ \
    {"BE", nn::util::Country_Be}, /* BE, 56, Belgium */ \
    {"BF", nn::util::Country_Bf}, /* BF, 854, Burkina Faso */ \
    {"BG", nn::util::Country_Bg}, /* BG, 100, Bulgaria */ \
    {"BH", nn::util::Country_Bh}, /* BH, 48, Bahrain */ \
    {"BI", nn::util::Country_Bi}, /* BI, 108, Burundi */ \
    {"BJ", nn::util::Country_Bj}, /* BJ, 204, Benin */ \
    {"BL", nn::util::Country_Bl}, /* BL, 652, Saint Barthélemy */ \
    {"BM", nn::util::Country_Bm}, /* BM, 60, Bermuda */ \
    {"BN", nn::util::Country_Bn}, /* BN, 96, Brunei Darussalam */ \
    {"BO", nn::util::Country_Bo}, /* BO, 68, Bolivia (Plurinational State of) */ \
    {"BQ", nn::util::Country_Bq}, /* BQ, 535, Bonaire, Sint Eustatius and Saba */ \
    {"BR", nn::util::Country_Br}, /* BR, 76, Brazil */ \
    {"BS", nn::util::Country_Bs}, /* BS, 44, Bahamas (the) */ \
    {"BT", nn::util::Country_Bt}, /* BT, 64, Bhutan */ \
    {"BV", nn::util::Country_Bv}, /* BV, 74, Bouvet Island */ \
    {"BW", nn::util::Country_Bw}, /* BW, 72, Botswana */ \
    {"BY", nn::util::Country_By}, /* BY, 112, Belarus */ \
    {"BZ", nn::util::Country_Bz}, /* BZ, 84, Belize */ \
    {"CA", nn::util::Country_Ca}, /* CA, 124, Canada */ \
    {"CC", nn::util::Country_Cc}, /* CC, 166, Cocos (Keeling) Islands (the) */ \
    {"CD", nn::util::Country_Cd}, /* CD, 180, Congo (the Democratic Republic of the) */ \
    {"CF", nn::util::Country_Cf}, /* CF, 140, Central African Republic (the) */ \
    {"CG", nn::util::Country_Cg}, /* CG, 178, Congo (the) */ \
    {"CH", nn::util::Country_Ch}, /* CH, 756, Switzerland */ \
    {"CI", nn::util::Country_Ci}, /* CI, 384, Côte d'Ivoire */ \
    {"CK", nn::util::Country_Ck}, /* CK, 184, Cook Islands (the) */ \
    {"CL", nn::util::Country_Cl}, /* CL, 152, Chile */ \
    {"CM", nn::util::Country_Cm}, /* CM, 120, Cameroon */ \
    {"CN", nn::util::Country_Cn}, /* CN, 156, China */ \
    {"CO", nn::util::Country_Co}, /* CO, 170, Colombia */ \
    {"CR", nn::util::Country_Cr}, /* CR, 188, Costa Rica */ \
    {"CU", nn::util::Country_Cu}, /* CU, 192, Cuba */ \
    {"CV", nn::util::Country_Cv}, /* CV, 132, Cabo Verde */ \
    {"CW", nn::util::Country_Cw}, /* CW, 531, Curaçao */ \
    {"CX", nn::util::Country_Cx}, /* CX, 162, Christmas Island */ \
    {"CY", nn::util::Country_Cy}, /* CY, 196, Cyprus */ \
    {"CZ", nn::util::Country_Cz}, /* CZ, 203, Czechia */ \
    {"DE", nn::util::Country_De}, /* DE, 276, Germany */ \
    {"DJ", nn::util::Country_Dj}, /* DJ, 262, Djibouti */ \
    {"DK", nn::util::Country_Dk}, /* DK, 208, Denmark */ \
    {"DM", nn::util::Country_Dm}, /* DM, 212, Dominica */ \
    {"DO", nn::util::Country_Do}, /* DO, 214, Dominican Republic (the) */ \
    {"DZ", nn::util::Country_Dz}, /* DZ, 12, Algeria */ \
    {"EC", nn::util::Country_Ec}, /* EC, 218, Ecuador */ \
    {"EE", nn::util::Country_Ee}, /* EE, 233, Estonia */ \
    {"EG", nn::util::Country_Eg}, /* EG, 818, Egypt */ \
    {"EH", nn::util::Country_Eh}, /* EH, 732, Western Sahara* */ \
    {"ER", nn::util::Country_Er}, /* ER, 232, Eritrea */ \
    {"ES", nn::util::Country_Es}, /* ES, 724, Spain */ \
    {"ET", nn::util::Country_Et}, /* ET, 231, Ethiopia */ \
    {"FI", nn::util::Country_Fi}, /* FI, 246, Finland */ \
    {"FJ", nn::util::Country_Fj}, /* FJ, 242, Fiji */ \
    {"FK", nn::util::Country_Fk}, /* FK, 238, Falkland Islands (the) [Malvinas] */ \
    {"FM", nn::util::Country_Fm}, /* FM, 583, Micronesia (Federated States of) */ \
    {"FO", nn::util::Country_Fo}, /* FO, 234, Faroe Islands (the) */ \
    {"FR", nn::util::Country_Fr}, /* FR, 250, France */ \
    {"GA", nn::util::Country_Ga}, /* GA, 266, Gabon */ \
    {"GB", nn::util::Country_Gb}, /* GB, 826, United Kingdom of Great Britain and Northern Ireland (the) */ \
    {"GD", nn::util::Country_Gd}, /* GD, 308, Grenada */ \
    {"GE", nn::util::Country_Ge}, /* GE, 268, Georgia */ \
    {"GF", nn::util::Country_Gf}, /* GF, 254, French Guiana */ \
    {"GG", nn::util::Country_Gg}, /* GG, 831, Guernsey */ \
    {"GH", nn::util::Country_Gh}, /* GH, 288, Ghana */ \
    {"GI", nn::util::Country_Gi}, /* GI, 292, Gibraltar */ \
    {"GL", nn::util::Country_Gl}, /* GL, 304, Greenland */ \
    {"GM", nn::util::Country_Gm}, /* GM, 270, Gambia (the) */ \
    {"GN", nn::util::Country_Gn}, /* GN, 324, Guinea */ \
    {"GP", nn::util::Country_Gp}, /* GP, 312, Guadeloupe */ \
    {"GQ", nn::util::Country_Gq}, /* GQ, 226, Equatorial Guinea */ \
    {"GR", nn::util::Country_Gr}, /* GR, 300, Greece */ \
    {"GS", nn::util::Country_Gs}, /* GS, 239, South Georgia and the South Sandwich Islands */ \
    {"GT", nn::util::Country_Gt}, /* GT, 320, Guatemala */ \
    {"GU", nn::util::Country_Gu}, /* GU, 316, Guam */ \
    {"GW", nn::util::Country_Gw}, /* GW, 624, Guinea-Bissau */ \
    {"GY", nn::util::Country_Gy}, /* GY, 328, Guyana */ \
    {"HK", nn::util::Country_Hk}, /* HK, 344, Hong Kong */ \
    {"HM", nn::util::Country_Hm}, /* HM, 334, Heard Island and McDonald Islands */ \
    {"HN", nn::util::Country_Hn}, /* HN, 340, Honduras */ \
    {"HR", nn::util::Country_Hr}, /* HR, 191, Croatia */ \
    {"HT", nn::util::Country_Ht}, /* HT, 332, Haiti */ \
    {"HU", nn::util::Country_Hu}, /* HU, 348, Hungary */ \
    {"ID", nn::util::Country_Id}, /* ID, 360, Indonesia */ \
    {"IE", nn::util::Country_Ie}, /* IE, 372, Ireland */ \
    {"IL", nn::util::Country_Il}, /* IL, 376, Israel */ \
    {"IM", nn::util::Country_Im}, /* IM, 833, Isle of Man */ \
    {"IN", nn::util::Country_In}, /* IN, 356, India */ \
    {"IO", nn::util::Country_Io}, /* IO, 86, British Indian Ocean Territory (the) */ \
    {"IQ", nn::util::Country_Iq}, /* IQ, 368, Iraq */ \
    {"IR", nn::util::Country_Ir}, /* IR, 364, Iran (Islamic Republic of) */ \
    {"IS", nn::util::Country_Is}, /* IS, 352, Iceland */ \
    {"IT", nn::util::Country_It}, /* IT, 380, Italy */ \
    {"JE", nn::util::Country_Je}, /* JE, 832, Jersey */ \
    {"JM", nn::util::Country_Jm}, /* JM, 388, Jamaica */ \
    {"JO", nn::util::Country_Jo}, /* JO, 400, Jordan */ \
    {"JP", nn::util::Country_Jp}, /* JP, 392, Japan */ \
    {"KE", nn::util::Country_Ke}, /* KE, 404, Kenya */ \
    {"KG", nn::util::Country_Kg}, /* KG, 417, Kyrgyzstan */ \
    {"KH", nn::util::Country_Kh}, /* KH, 116, Cambodia */ \
    {"KI", nn::util::Country_Ki}, /* KI, 296, Kiribati */ \
    {"KM", nn::util::Country_Km}, /* KM, 174, Comoros (the) */ \
    {"KN", nn::util::Country_Kn}, /* KN, 659, Saint Kitts and Nevis */ \
    {"KP", nn::util::Country_Kp}, /* KP, 408, Korea (the Democratic People's Republic of) */ \
    {"KR", nn::util::Country_Kr}, /* KR, 410, Korea (the Republic of) */ \
    {"KW", nn::util::Country_Kw}, /* KW, 414, Kuwait */ \
    {"KY", nn::util::Country_Ky}, /* KY, 136, Cayman Islands (the) */ \
    {"KZ", nn::util::Country_Kz}, /* KZ, 398, Kazakhstan */ \
    {"LA", nn::util::Country_La}, /* LA, 418, Lao People's Democratic Republic (the) */ \
    {"LB", nn::util::Country_Lb}, /* LB, 422, Lebanon */ \
    {"LC", nn::util::Country_Lc}, /* LC, 662, Saint Lucia */ \
    {"LI", nn::util::Country_Li}, /* LI, 438, Liechtenstein */ \
    {"LK", nn::util::Country_Lk}, /* LK, 144, Sri Lanka */ \
    {"LR", nn::util::Country_Lr}, /* LR, 430, Liberia */ \
    {"LS", nn::util::Country_Ls}, /* LS, 426, Lesotho */ \
    {"LT", nn::util::Country_Lt}, /* LT, 440, Lithuania */ \
    {"LU", nn::util::Country_Lu}, /* LU, 442, Luxembourg */ \
    {"LV", nn::util::Country_Lv}, /* LV, 428, Latvia */ \
    {"LY", nn::util::Country_Ly}, /* LY, 434, Libya */ \
    {"MA", nn::util::Country_Ma}, /* MA, 504, Morocco */ \
    {"MC", nn::util::Country_Mc}, /* MC, 492, Monaco */ \
    {"MD", nn::util::Country_Md}, /* MD, 498, Moldova (the Republic of) */ \
    {"ME", nn::util::Country_Me}, /* ME, 499, Montenegro */ \
    {"MF", nn::util::Country_Mf}, /* MF, 663, Saint Martin (French part) */ \
    {"MG", nn::util::Country_Mg}, /* MG, 450, Madagascar */ \
    {"MH", nn::util::Country_Mh}, /* MH, 584, Marshall Islands (the) */ \
    {"MK", nn::util::Country_Mk}, /* MK, 807, Macedonia (the former Yugoslav Republic of) */ \
    {"ML", nn::util::Country_Ml}, /* ML, 466, Mali */ \
    {"MM", nn::util::Country_Mm}, /* MM, 104, Myanmar */ \
    {"MN", nn::util::Country_Mn}, /* MN, 496, Mongolia */ \
    {"MO", nn::util::Country_Mo}, /* MO, 446, Macao */ \
    {"MP", nn::util::Country_Mp}, /* MP, 580, Northern Mariana Islands (the) */ \
    {"MQ", nn::util::Country_Mq}, /* MQ, 474, Martinique */ \
    {"MR", nn::util::Country_Mr}, /* MR, 478, Mauritania */ \
    {"MS", nn::util::Country_Ms}, /* MS, 500, Montserrat */ \
    {"MT", nn::util::Country_Mt}, /* MT, 470, Malta */ \
    {"MU", nn::util::Country_Mu}, /* MU, 480, Mauritius */ \
    {"MV", nn::util::Country_Mv}, /* MV, 462, Maldives */ \
    {"MW", nn::util::Country_Mw}, /* MW, 454, Malawi */ \
    {"MX", nn::util::Country_Mx}, /* MX, 484, Mexico */ \
    {"MY", nn::util::Country_My}, /* MY, 458, Malaysia */ \
    {"MZ", nn::util::Country_Mz}, /* MZ, 508, Mozambique */ \
    {"NA", nn::util::Country_Na}, /* NA, 516, Namibia */ \
    {"NC", nn::util::Country_Nc}, /* NC, 540, New Caledonia */ \
    {"NE", nn::util::Country_Ne}, /* NE, 562, Niger (the) */ \
    {"NF", nn::util::Country_Nf}, /* NF, 574, Norfolk Island */ \
    {"NG", nn::util::Country_Ng}, /* NG, 566, Nigeria */ \
    {"NI", nn::util::Country_Ni}, /* NI, 558, Nicaragua */ \
    {"NL", nn::util::Country_Nl}, /* NL, 528, Netherlands (the) */ \
    {"NO", nn::util::Country_No}, /* NO, 578, Norway */ \
    {"NP", nn::util::Country_Np}, /* NP, 524, Nepal */ \
    {"NR", nn::util::Country_Nr}, /* NR, 520, Nauru */ \
    {"NU", nn::util::Country_Nu}, /* NU, 570, Niue */ \
    {"NZ", nn::util::Country_Nz}, /* NZ, 554, New Zealand */ \
    {"OM", nn::util::Country_Om}, /* OM, 512, Oman */ \
    {"PA", nn::util::Country_Pa}, /* PA, 591, Panama */ \
    {"PE", nn::util::Country_Pe}, /* PE, 604, Peru */ \
    {"PF", nn::util::Country_Pf}, /* PF, 258, French Polynesia */ \
    {"PG", nn::util::Country_Pg}, /* PG, 598, Papua New Guinea */ \
    {"PH", nn::util::Country_Ph}, /* PH, 608, Philippines (the) */ \
    {"PK", nn::util::Country_Pk}, /* PK, 586, Pakistan */ \
    {"PL", nn::util::Country_Pl}, /* PL, 616, Poland */ \
    {"PM", nn::util::Country_Pm}, /* PM, 666, Saint Pierre and Miquelon */ \
    {"PN", nn::util::Country_Pn}, /* PN, 612, Pitcairn */ \
    {"PR", nn::util::Country_Pr}, /* PR, 630, Puerto Rico */ \
    {"PS", nn::util::Country_Ps}, /* PS, 275, Palestine, State of */ \
    {"PT", nn::util::Country_Pt}, /* PT, 620, Portugal */ \
    {"PW", nn::util::Country_Pw}, /* PW, 585, Palau */ \
    {"PY", nn::util::Country_Py}, /* PY, 600, Paraguay */ \
    {"QA", nn::util::Country_Qa}, /* QA, 634, Qatar */ \
    {"RE", nn::util::Country_Re}, /* RE, 638, Réunion */ \
    {"RO", nn::util::Country_Ro}, /* RO, 642, Romania */ \
    {"RS", nn::util::Country_Rs}, /* RS, 688, Serbia */ \
    {"RU", nn::util::Country_Ru}, /* RU, 643, Russian Federation (the) */ \
    {"RW", nn::util::Country_Rw}, /* RW, 646, Rwanda */ \
    {"SA", nn::util::Country_Sa}, /* SA, 682, Saudi Arabia */ \
    {"SB", nn::util::Country_Sb}, /* SB, 90, Solomon Islands */ \
    {"SC", nn::util::Country_Sc}, /* SC, 690, Seychelles */ \
    {"SD", nn::util::Country_Sd}, /* SD, 729, Sudan (the) */ \
    {"SE", nn::util::Country_Se}, /* SE, 752, Sweden */ \
    {"SG", nn::util::Country_Sg}, /* SG, 702, Singapore */ \
    {"SH", nn::util::Country_Sh}, /* SH, 654, Saint Helena, Ascension and Tristan da Cunha */ \
    {"SI", nn::util::Country_Si}, /* SI, 705, Slovenia */ \
    {"SJ", nn::util::Country_Sj}, /* SJ, 744, Svalbard and Jan Mayen */ \
    {"SK", nn::util::Country_Sk}, /* SK, 703, Slovakia */ \
    {"SL", nn::util::Country_Sl}, /* SL, 694, Sierra Leone */ \
    {"SM", nn::util::Country_Sm}, /* SM, 674, San Marino */ \
    {"SN", nn::util::Country_Sn}, /* SN, 686, Senegal */ \
    {"SO", nn::util::Country_So}, /* SO, 706, Somalia */ \
    {"SR", nn::util::Country_Sr}, /* SR, 740, Suriname */ \
    {"SS", nn::util::Country_Ss}, /* SS, 728, South Sudan */ \
    {"ST", nn::util::Country_St}, /* ST, 678, Sao Tome and Principe */ \
    {"SV", nn::util::Country_Sv}, /* SV, 222, El Salvador */ \
    {"SX", nn::util::Country_Sx}, /* SX, 534, Sint Maarten (Dutch part) */ \
    {"SY", nn::util::Country_Sy}, /* SY, 760, Syrian Arab Republic */ \
    {"SZ", nn::util::Country_Sz}, /* SZ, 748, Swaziland */ \
    {"TC", nn::util::Country_Tc}, /* TC, 796, Turks and Caicos Islands (the) */ \
    {"TD", nn::util::Country_Td}, /* TD, 148, Chad */ \
    {"TF", nn::util::Country_Tf}, /* TF, 260, French Southern Territories (the) */ \
    {"TG", nn::util::Country_Tg}, /* TG, 768, Togo */ \
    {"TH", nn::util::Country_Th}, /* TH, 764, Thailand */ \
    {"TJ", nn::util::Country_Tj}, /* TJ, 762, Tajikistan */ \
    {"TK", nn::util::Country_Tk}, /* TK, 772, Tokelau */ \
    {"TL", nn::util::Country_Tl}, /* TL, 626, Timor-Leste */ \
    {"TM", nn::util::Country_Tm}, /* TM, 795, Turkmenistan */ \
    {"TN", nn::util::Country_Tn}, /* TN, 788, Tunisia */ \
    {"TO", nn::util::Country_To}, /* TO, 776, Tonga */ \
    {"TR", nn::util::Country_Tr}, /* TR, 792, Turkey */ \
    {"TT", nn::util::Country_Tt}, /* TT, 780, Trinidad and Tobago */ \
    {"TV", nn::util::Country_Tv}, /* TV, 798, Tuvalu */ \
    {"TW", nn::util::Country_Tw}, /* TW, 158, Taiwan (Province of China) */ \
    {"TZ", nn::util::Country_Tz}, /* TZ, 834, Tanzania, United Republic of */ \
    {"UA", nn::util::Country_Ua}, /* UA, 804, Ukraine */ \
    {"UG", nn::util::Country_Ug}, /* UG, 800, Uganda */ \
    {"UM", nn::util::Country_Um}, /* UM, 581, United States Minor Outlying Islands (the) */ \
    {"US", nn::util::Country_Us}, /* US, 840, United States of America (the) */ \
    {"UY", nn::util::Country_Uy}, /* UY, 858, Uruguay */ \
    {"UZ", nn::util::Country_Uz}, /* UZ, 860, Uzbekistan */ \
    {"VA", nn::util::Country_Va}, /* VA, 336, Holy See (the) */ \
    {"VC", nn::util::Country_Vc}, /* VC, 670, Saint Vincent and the Grenadines */ \
    {"VE", nn::util::Country_Ve}, /* VE, 862, Venezuela (Bolivarian Republic of) */ \
    {"VG", nn::util::Country_Vg}, /* VG, 92, Virgin Islands (British) */ \
    {"VI", nn::util::Country_Vi}, /* VI, 850, Virgin Islands (U.S.) */ \
    {"VN", nn::util::Country_Vn}, /* VN, 704, Viet Nam */ \
    {"VU", nn::util::Country_Vu}, /* VU, 548, Vanuatu */ \
    {"WF", nn::util::Country_Wf}, /* WF, 876, Wallis and Futuna */ \
    {"WS", nn::util::Country_Ws}, /* WS, 882, Samoa */ \
    {"YE", nn::util::Country_Ye}, /* YE, 887, Yemen */ \
    {"YT", nn::util::Country_Yt}, /* YT, 175, Mayotte */ \
    {"ZA", nn::util::Country_Za}, /* ZA, 710, South Africa */ \
    {"ZM", nn::util::Country_Zm}, /* ZM, 894, Zambia */ \
    {"ZW", nn::util::Country_Zw}, /* ZW, 716, Zimbabwe */

namespace basic {
template <size_t N>
struct Input
{
    char code[N];
    nn::util::Country country;
};
const Input<3> Tests3[] = {
    SUCCESS_TEST_CASES
};
const Input<32> Tests32[] = {
    SUCCESS_TEST_CASES
};

template <typename T, size_t Count>
void Test(const T (&tests)[Count])
{
    for (const auto& t : tests)
    {
        nn::util::Country country;
        auto r = nn::util::GetCountryFromIso31661Alpha2(&country, t.code, sizeof(t.code));
        EXPECT_TRUE(r);
        EXPECT_EQ(t.country, country);
    }
}
} // ~namespace basic

TEST(UtilCountry, Basic)
{
    basic::Test<>(basic::Tests3);
    basic::Test<>(basic::Tests32);
}

namespace error {
template <size_t N>
struct Input
{
    char code[N];
};
const Input<4> Tests4[] = {
    {""},
    {" "},
    {"  "},
    {"J"},
    {"J0"},
    {"1P"},
    {"J-"},
    {"_P"},
    {"JPP"},
    {"JP "},
};
const Input<2> Tests2[] = {
    {""},
    {"J"},
};

template <typename T, size_t Count>
void Test(const T (&tests)[Count])
{
    for (const auto& t : tests)
    {
        nn::util::Country country;
        auto r = nn::util::GetCountryFromIso31661Alpha2(&country, t.code, sizeof(t.code));
        EXPECT_FALSE(r);
    }
}
} // ~namespace error

TEST(UtilCountry, Error)
{
    error::Test<>(error::Tests4);
    error::Test<>(error::Tests2);
}
