﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testUtil_BenchmarkMatrixApiWrapper.general.h"

namespace nn {
namespace util {
namespace general {

void MatrixLoadWrapper(MatrixRowMajor3x2fType* pOutValue, const FloatRowMajor3x2& source)
{
    return MatrixLoad(pOutValue, source);
}
void MatrixLoadWrapper(MatrixRowMajor3x2fType* pOutValue, const FloatColumnMajor3x2& source)
{
    return MatrixLoad(pOutValue, source);
}
void MatrixLoadWrapper(MatrixColumnMajor3x2fType* pOutValue, const FloatRowMajor3x2& source)
{
    return MatrixLoad(pOutValue, source);
}
void MatrixLoadWrapper(MatrixColumnMajor3x2fType* pOutValue, const FloatColumnMajor3x2& source)
{
    return MatrixLoad(pOutValue, source);
}
void MatrixStoreWrapper(FloatRowMajor3x2* pOutValue, const MatrixRowMajor3x2fType& source)
{
    return MatrixStore(pOutValue, source);
}
void MatrixStoreWrapper(FloatRowMajor3x2* pOutValue, const MatrixColumnMajor3x2fType& source)
{
    return MatrixStore(pOutValue, source);
}
void MatrixStoreWrapper(FloatColumnMajor3x2* pOutValue, const MatrixRowMajor3x2fType& source)
{
    return MatrixStore(pOutValue, source);
}
void MatrixStoreWrapper(FloatColumnMajor3x2* pOutValue, const MatrixColumnMajor3x2fType& source)
{
    return MatrixStore(pOutValue, source);
}
void MatrixSetWrapper(MatrixRowMajor3x2fType* pOutValue, float m00, float m01, float m10, float m11, float m20, float m21)
{
    return MatrixSet(pOutValue, m00, m01, m10, m11, m20, m21);
}
void MatrixSetWrapper(MatrixColumnMajor3x2fType* pOutValue, float m00, float m01, float m10, float m11, float m20, float m21)
{
    return MatrixSet(pOutValue, m00, m01, m10, m11, m20, m21);
}
void MatrixSetRowWrapper(MatrixRowMajor3x2fType* pOutValue, int index, const Vector2fType& vector)
{
    return MatrixSetRow(pOutValue, index, vector);
}
void MatrixSetRowWrapper(MatrixColumnMajor3x2fType* pOutValue, int index, const Vector2fType& vector)
{
    return MatrixSetRow(pOutValue, index, vector);
}
void MatrixSetRowsWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& row0, const Vector2fType& row1, const Vector2fType& row2)
{
    return MatrixSetRows(pOutValue, row0, row1, row2);
}
void MatrixSetRowsWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& row0, const Vector2fType& row1, const Vector2fType& row2)
{
    return MatrixSetRows(pOutValue, row0, row1, row2);
}
void MatrixGetRowWrapper(Vector2fType* pOutValue, const MatrixRowMajor3x2fType& matrix, int index)
{
    return MatrixGetRow(pOutValue, matrix, index);
}
void MatrixGetRowWrapper(Vector2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix, int index)
{
    return MatrixGetRow(pOutValue, matrix, index);
}
void MatrixGetRowsWrapper(Vector2fType* pOutRow0, Vector2fType* pOutRow1, Vector2fType* pOutRow2, const MatrixRowMajor3x2fType& matrix)
{
    return MatrixGetRows(pOutRow0, pOutRow1, pOutRow2, matrix);
}
void MatrixGetRowsWrapper(Vector2fType* pOutRow0, Vector2fType* pOutRow1, Vector2fType* pOutRow2, const MatrixColumnMajor3x2fType& matrix)
{
    return MatrixGetRows(pOutRow0, pOutRow1, pOutRow2, matrix);
}
void MatrixSetColumnWrapper(MatrixRowMajor3x2fType* pOutValue, int index, const Vector3fType& vector)
{
    return MatrixSetColumn(pOutValue, index, vector);
}
void MatrixSetColumnWrapper(MatrixColumnMajor3x2fType* pOutValue, int index, const Vector3fType& vector)
{
    return MatrixSetColumn(pOutValue, index, vector);
}
void MatrixSetColumnsWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector3fType& column0, const Vector3fType& column1)
{
    return MatrixSetColumns(pOutValue, column0, column1);
}
void MatrixSetColumnsWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector3fType& column0, const Vector3fType& column1)
{
    return MatrixSetColumns(pOutValue, column0, column1);
}
void MatrixGetColumnWrapper(Vector3fType* pOutValue, const MatrixRowMajor3x2fType& matrix, int index)
{
    return MatrixGetColumn(pOutValue, matrix, index);
}
void MatrixGetColumnWrapper(Vector3fType* pOutValue, const MatrixColumnMajor3x2fType& matrix, int index)
{
    return MatrixGetColumn(pOutValue, matrix, index);
}
void MatrixGetColumnsWrapper(Vector3fType* pOutColumn0, Vector3fType* pOutColumn1, const MatrixRowMajor3x2fType& matrix)
{
    return MatrixGetColumns(pOutColumn0, pOutColumn1, matrix);
}
void MatrixGetColumnsWrapper(Vector3fType* pOutColumn0, Vector3fType* pOutColumn1, const MatrixColumnMajor3x2fType& matrix)
{
    return MatrixGetColumns(pOutColumn0, pOutColumn1, matrix);
}
void MatrixSetAxisXWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& vector)
{
    return MatrixSetAxisX(pOutValue, vector);
}
void MatrixSetAxisXWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& vector)
{
    return MatrixSetAxisX(pOutValue, vector);
}
void MatrixSetAxisYWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& vector)
{
    return MatrixSetAxisY(pOutValue, vector);
}
void MatrixSetAxisYWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& vector)
{
    return MatrixSetAxisY(pOutValue, vector);
}
void MatrixSetAxisZWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& vector)
{
    return MatrixSetAxisZ(pOutValue, vector);
}
void MatrixSetAxisZWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& vector)
{
    return MatrixSetAxisZ(pOutValue, vector);
}
void MatrixSetAxesWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& axisX, const Vector2fType& axisY, const Vector2fType& axisZ)
{
    return MatrixSetAxes(pOutValue, axisX, axisY, axisZ);
}
void MatrixSetAxesWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& axisX, const Vector2fType& axisY, const Vector2fType& axisZ)
{
    return MatrixSetAxes(pOutValue, axisX, axisY, axisZ);
}
void MatrixGetAxisXWrapper(Vector2fType* pOutValue, const MatrixRowMajor3x2fType& matrix)
{
    return MatrixGetAxisX(pOutValue, matrix);
}
void MatrixGetAxisXWrapper(Vector2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix)
{
    return MatrixGetAxisX(pOutValue, matrix);
}
void MatrixGetAxisYWrapper(Vector2fType* pOutValue, const MatrixRowMajor3x2fType& matrix)
{
    return MatrixGetAxisY(pOutValue, matrix);
}
void MatrixGetAxisYWrapper(Vector2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix)
{
    return MatrixGetAxisY(pOutValue, matrix);
}
void MatrixGetAxisZWrapper(Vector2fType* pOutValue, const MatrixRowMajor3x2fType& matrix)
{
    return MatrixGetAxisZ(pOutValue, matrix);
}
void MatrixGetAxisZWrapper(Vector2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix)
{
    return MatrixGetAxisZ(pOutValue, matrix);
}
void MatrixGetAxesWrapper(Vector2fType* pOutAxisX, Vector2fType* pOutAxisY, Vector2fType* pOutAxisZ, const MatrixRowMajor3x2fType& matrix)
{
    return MatrixGetAxes(pOutAxisX, pOutAxisY, pOutAxisZ, matrix);
}
void MatrixGetAxesWrapper(Vector2fType* pOutAxisX, Vector2fType* pOutAxisY, Vector2fType* pOutAxisZ, const MatrixColumnMajor3x2fType& matrix)
{
    return MatrixGetAxes(pOutAxisX, pOutAxisY, pOutAxisZ, matrix);
}
void MatrixZeroWrapper(MatrixRowMajor3x2fType* pOutValue)
{
    return MatrixZero(pOutValue);
}
void MatrixZeroWrapper(MatrixColumnMajor3x2fType* pOutValue)
{
    return MatrixZero(pOutValue);
}
void MatrixIdentityWrapper(MatrixRowMajor3x2fType* pOutValue)
{
    return MatrixIdentity(pOutValue);
}
void MatrixIdentityWrapper(MatrixColumnMajor3x2fType* pOutValue)
{
    return MatrixIdentity(pOutValue);
}
void MatrixAddWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix1, const MatrixRowMajor3x2fType& matrix2)
{
    return MatrixAdd(pOutValue, matrix1, matrix2);
}
void MatrixAddWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix1, const MatrixColumnMajor3x2fType& matrix2)
{
    return MatrixAdd(pOutValue, matrix1, matrix2);
}
void MatrixSubtractWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix1, const MatrixRowMajor3x2fType& matrix2)
{
    return MatrixSubtract(pOutValue, matrix1, matrix2);
}
void MatrixSubtractWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix1, const MatrixColumnMajor3x2fType& matrix2)
{
    return MatrixSubtract(pOutValue, matrix1, matrix2);
}
void MatrixMultiplyWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix, float factor)
{
    return MatrixMultiply(pOutValue, matrix, factor);
}
void MatrixMultiplyWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix, float factor)
{
    return MatrixMultiply(pOutValue, matrix, factor);
}
void MatrixMultiplyWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix1, const MatrixRowMajor3x2fType& matrix2)
{
    return MatrixMultiply(pOutValue, matrix1, matrix2);
}
void MatrixMultiplyWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix1, const MatrixColumnMajor3x2fType& matrix2)
{
    return MatrixMultiply(pOutValue, matrix1, matrix2);
}
void MatrixMultiplyAddWrapper(MatrixRowMajor3x2fType* pOutValue, float t, const MatrixRowMajor3x2fType& matrix1, const MatrixRowMajor3x2fType& matrix2)
{
    return MatrixMultiplyAdd(pOutValue, t, matrix1, matrix2);
}
void MatrixMultiplyAddWrapper(MatrixColumnMajor3x2fType* pOutValue, float t, const MatrixColumnMajor3x2fType& matrix1, const MatrixColumnMajor3x2fType& matrix2)
{
    return MatrixMultiplyAdd(pOutValue, t, matrix1, matrix2);
}
void MatrixDivideWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix, float factor)
{
    return MatrixDivide(pOutValue, matrix, factor);
}
void MatrixDivideWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix, float factor)
{
    return MatrixDivide(pOutValue, matrix, factor);
}
bool MatrixInverseWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix)
{
    return MatrixInverse(pOutValue, matrix);
}
bool MatrixInverseWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix)
{
    return MatrixInverse(pOutValue, matrix);
}
void MatrixTransposeWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix)
{
    return MatrixTranspose(pOutValue, matrix);
}
void MatrixTransposeWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix)
{
    return MatrixTranspose(pOutValue, matrix);
}
bool MatrixInverseTransposeWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix)
{
    return MatrixInverseTranspose(pOutValue, matrix);
}
bool MatrixInverseTransposeWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix)
{
    return MatrixInverseTranspose(pOutValue, matrix);
}
void MatrixSetTranslateWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& translate)
{
    return MatrixSetTranslate(pOutValue, translate);
}
void MatrixSetTranslateWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& translate)
{
    return MatrixSetTranslate(pOutValue, translate);
}
void MatrixSetScaleWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& scale)
{
    return MatrixSetScale(pOutValue, scale);
}
void MatrixSetScaleWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& scale)
{
    return MatrixSetScale(pOutValue, scale);
}
void MatrixSetRotateWrapper(MatrixRowMajor3x2fType* pOutValue, float rotationRadian)
{
    return MatrixSetRotate(pOutValue, rotationRadian);
}
void MatrixSetRotateWrapper(MatrixColumnMajor3x2fType* pOutValue, float rotationRadian)
{
    return MatrixSetRotate(pOutValue, rotationRadian);
}
void MatrixSetScaleRotateWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& scale, float rotationRadian)
{
    return MatrixSetScaleRotate(pOutValue, scale, rotationRadian);
}
void MatrixSetScaleRotateWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& scale, float rotationRadian)
{
    return MatrixSetScaleRotate(pOutValue, scale, rotationRadian);
}
void MatrixFromQuaternionWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector4fType& quaternion)
{
    return MatrixFromQuaternion(pOutValue, quaternion);
}
void MatrixFromQuaternionWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector4fType& quaternion)
{
    return MatrixFromQuaternion(pOutValue, quaternion);
}
void MatrixLoadWrapper(MatrixRowMajor4x3fType* pOutValue, const FloatRowMajor4x3& source)
{
    return MatrixLoad(pOutValue, source);
}
void MatrixLoadWrapper(MatrixRowMajor4x3fType* pOutValue, const FloatColumnMajor4x3& source)
{
    return MatrixLoad(pOutValue, source);
}
void MatrixLoadWrapper(MatrixColumnMajor4x3fType* pOutValue, const FloatRowMajor4x3& source)
{
    return MatrixLoad(pOutValue, source);
}
void MatrixLoadWrapper(MatrixColumnMajor4x3fType* pOutValue, const FloatColumnMajor4x3& source)
{
    return MatrixLoad(pOutValue, source);
}
void MatrixStoreWrapper(FloatRowMajor4x3* pOutValue, const MatrixRowMajor4x3fType& source)
{
    return MatrixStore(pOutValue, source);
}
void MatrixStoreWrapper(FloatRowMajor4x3* pOutValue, const MatrixColumnMajor4x3fType& source)
{
    return MatrixStore(pOutValue, source);
}
void MatrixStoreWrapper(FloatColumnMajor4x3* pOutValue, const MatrixRowMajor4x3fType& source)
{
    return MatrixStore(pOutValue, source);
}
void MatrixStoreWrapper(FloatColumnMajor4x3* pOutValue, const MatrixColumnMajor4x3fType& source)
{
    return MatrixStore(pOutValue, source);
}
void MatrixConvertWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x3fType& source)
{
    return MatrixConvert(pOutValue, source);
}
void MatrixConvertWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x3fType& source)
{
    return MatrixConvert(pOutValue, source);
}
void MatrixSetWrapper(MatrixRowMajor4x3fType* pOutValue, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, float m30, float m31, float m32)
{
    return MatrixSet(pOutValue, m00, m01, m02, m10, m11, m12, m20, m21, m22, m30, m31, m32);
}
void MatrixSetWrapper(MatrixColumnMajor4x3fType* pOutValue, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, float m30, float m31, float m32)
{
    return MatrixSet(pOutValue, m00, m01, m02, m10, m11, m12, m20, m21, m22, m30, m31, m32);
}
void MatrixSetRowWrapper(MatrixRowMajor4x3fType* pOutValue, int index, const Vector3fType& vector)
{
    return MatrixSetRow(pOutValue, index, vector);
}
void MatrixSetRowWrapper(MatrixColumnMajor4x3fType* pOutValue, int index, const Vector3fType& vector)
{
    return MatrixSetRow(pOutValue, index, vector);
}
void MatrixSetRowsWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& row0, const Vector3fType& row1, const Vector3fType& row2, const Vector3fType& row3)
{
    return MatrixSetRows(pOutValue, row0, row1, row2, row3);
}
void MatrixSetRowsWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& row0, const Vector3fType& row1, const Vector3fType& row2, const Vector3fType& row3)
{
    return MatrixSetRows(pOutValue, row0, row1, row2, row3);
}
void MatrixGetRowWrapper(Vector3fType* pOutValue, const MatrixRowMajor4x3fType& matrix, int index)
{
    return MatrixGetRow(pOutValue, matrix, index);
}
void MatrixGetRowWrapper(Vector3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix, int index)
{
    return MatrixGetRow(pOutValue, matrix, index);
}
void MatrixGetRowsWrapper(Vector3fType* pOutRow0, Vector3fType* pOutRow1, Vector3fType* pOutRow2, Vector3fType* pOutRow3, const MatrixRowMajor4x3fType& matrix)
{
    return MatrixGetRows(pOutRow0, pOutRow1, pOutRow2, pOutRow3, matrix);
}
void MatrixGetRowsWrapper(Vector3fType* pOutRow0, Vector3fType* pOutRow1, Vector3fType* pOutRow2, Vector3fType* pOutRow3, const MatrixColumnMajor4x3fType& matrix)
{
    return MatrixGetRows(pOutRow0, pOutRow1, pOutRow2, pOutRow3, matrix);
}
void MatrixSetColumnWrapper(MatrixRowMajor4x3fType* pOutValue, int index, const Vector4fType& vector)
{
    return MatrixSetColumn(pOutValue, index, vector);
}
void MatrixSetColumnWrapper(MatrixColumnMajor4x3fType* pOutValue, int index, const Vector4fType& vector)
{
    return MatrixSetColumn(pOutValue, index, vector);
}
void MatrixSetColumnsWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector4fType& column0, const Vector4fType& column1, const Vector4fType& column2)
{
    return MatrixSetColumns(pOutValue, column0, column1, column2);
}
void MatrixSetColumnsWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector4fType& column0, const Vector4fType& column1, const Vector4fType& column2)
{
    return MatrixSetColumns(pOutValue, column0, column1, column2);
}
void MatrixGetColumnWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x3fType& matrix, int index)
{
    return MatrixGetColumn(pOutValue, matrix, index);
}
void MatrixGetColumnWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x3fType& matrix, int index)
{
    return MatrixGetColumn(pOutValue, matrix, index);
}
void MatrixGetColumnsWrapper(Vector4fType* pOutColumn0, Vector4fType* pOutColumn1, Vector4fType* pOutColumn2, const MatrixRowMajor4x3fType& matrix)
{
    return MatrixGetColumns(pOutColumn0, pOutColumn1, pOutColumn2, matrix);
}
void MatrixGetColumnsWrapper(Vector4fType* pOutColumn0, Vector4fType* pOutColumn1, Vector4fType* pOutColumn2, const MatrixColumnMajor4x3fType& matrix)
{
    return MatrixGetColumns(pOutColumn0, pOutColumn1, pOutColumn2, matrix);
}
void MatrixSetAxisXWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& vector)
{
    return MatrixSetAxisX(pOutValue, vector);
}
void MatrixSetAxisXWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& vector)
{
    return MatrixSetAxisX(pOutValue, vector);
}
void MatrixSetAxisYWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& vector)
{
    return MatrixSetAxisY(pOutValue, vector);
}
void MatrixSetAxisYWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& vector)
{
    return MatrixSetAxisY(pOutValue, vector);
}
void MatrixSetAxisZWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& vector)
{
    return MatrixSetAxisZ(pOutValue, vector);
}
void MatrixSetAxisZWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& vector)
{
    return MatrixSetAxisZ(pOutValue, vector);
}
void MatrixSetAxisWWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& vector)
{
    return MatrixSetAxisW(pOutValue, vector);
}
void MatrixSetAxisWWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& vector)
{
    return MatrixSetAxisW(pOutValue, vector);
}
void MatrixSetAxesWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& axisX, const Vector3fType& axisY, const Vector3fType& axisZ, const Vector3fType& axisW)
{
    return MatrixSetAxes(pOutValue, axisX, axisY, axisZ, axisW);
}
void MatrixSetAxesWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& axisX, const Vector3fType& axisY, const Vector3fType& axisZ, const Vector3fType& axisW)
{
    return MatrixSetAxes(pOutValue, axisX, axisY, axisZ, axisW);
}
void MatrixGetAxisXWrapper(Vector3fType* pOutValue, const MatrixRowMajor4x3fType& matrix)
{
    return MatrixGetAxisX(pOutValue, matrix);
}
void MatrixGetAxisXWrapper(Vector3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix)
{
    return MatrixGetAxisX(pOutValue, matrix);
}
void MatrixGetAxisYWrapper(Vector3fType* pOutValue, const MatrixRowMajor4x3fType& matrix)
{
    return MatrixGetAxisY(pOutValue, matrix);
}
void MatrixGetAxisYWrapper(Vector3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix)
{
    return MatrixGetAxisY(pOutValue, matrix);
}
void MatrixGetAxisZWrapper(Vector3fType* pOutValue, const MatrixRowMajor4x3fType& matrix)
{
    return MatrixGetAxisZ(pOutValue, matrix);
}
void MatrixGetAxisZWrapper(Vector3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix)
{
    return MatrixGetAxisZ(pOutValue, matrix);
}
void MatrixGetAxisWWrapper(Vector3fType* pOutValue, const MatrixRowMajor4x3fType& matrix)
{
    return MatrixGetAxisW(pOutValue, matrix);
}
void MatrixGetAxisWWrapper(Vector3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix)
{
    return MatrixGetAxisW(pOutValue, matrix);
}
void MatrixGetAxesWrapper(Vector3fType* pOutAxisX, Vector3fType* pOutAxisY, Vector3fType* pOutAxisZ, Vector3fType* pOutAxisW, const MatrixRowMajor4x3fType& matrix)
{
    return MatrixGetAxes(pOutAxisX, pOutAxisY, pOutAxisZ, pOutAxisW, matrix);
}
void MatrixGetAxesWrapper(Vector3fType* pOutAxisX, Vector3fType* pOutAxisY, Vector3fType* pOutAxisZ, Vector3fType* pOutAxisW, const MatrixColumnMajor4x3fType& matrix)
{
    return MatrixGetAxes(pOutAxisX, pOutAxisY, pOutAxisZ, pOutAxisW, matrix);
}
void MatrixZeroWrapper(MatrixRowMajor4x3fType* pOutValue)
{
    return MatrixZero(pOutValue);
}
void MatrixZeroWrapper(MatrixColumnMajor4x3fType* pOutValue)
{
    return MatrixZero(pOutValue);
}
void MatrixIdentityWrapper(MatrixRowMajor4x3fType* pOutValue)
{
    return MatrixIdentity(pOutValue);
}
void MatrixIdentityWrapper(MatrixColumnMajor4x3fType* pOutValue)
{
    return MatrixIdentity(pOutValue);
}
void MatrixAddWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix1, const MatrixRowMajor4x3fType& matrix2)
{
    return MatrixAdd(pOutValue, matrix1, matrix2);
}
void MatrixAddWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix1, const MatrixColumnMajor4x3fType& matrix2)
{
    return MatrixAdd(pOutValue, matrix1, matrix2);
}
void MatrixSubtractWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix1, const MatrixRowMajor4x3fType& matrix2)
{
    return MatrixSubtract(pOutValue, matrix1, matrix2);
}
void MatrixSubtractWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix1, const MatrixColumnMajor4x3fType& matrix2)
{
    return MatrixSubtract(pOutValue, matrix1, matrix2);
}
void MatrixMultiplyWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix, float factor)
{
    return MatrixMultiply(pOutValue, matrix, factor);
}
void MatrixMultiplyWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix, float factor)
{
    return MatrixMultiply(pOutValue, matrix, factor);
}
void MatrixMultiplyWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix1, const MatrixRowMajor4x3fType& matrix2)
{
    return MatrixMultiply(pOutValue, matrix1, matrix2);
}
void MatrixMultiplyWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix1, const MatrixColumnMajor4x3fType& matrix2)
{
    return MatrixMultiply(pOutValue, matrix1, matrix2);
}
void MatrixMultiplyWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x3fType& matrix1, const MatrixRowMajor4x4fType& matrix2)
{
    return MatrixMultiply(pOutValue, matrix1, matrix2);
}
void MatrixMultiplyWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x3fType& matrix1, const MatrixColumnMajor4x4fType& matrix2)
{
    return MatrixMultiply(pOutValue, matrix1, matrix2);
}
void MatrixMultiplyAddWrapper(MatrixRowMajor4x3fType* pOutValue, float t, const MatrixRowMajor4x3fType& matrix1, const MatrixRowMajor4x3fType& matrix2)
{
    return MatrixMultiplyAdd(pOutValue, t, matrix1, matrix2);
}
void MatrixMultiplyAddWrapper(MatrixColumnMajor4x3fType* pOutValue, float t, const MatrixColumnMajor4x3fType& matrix1, const MatrixColumnMajor4x3fType& matrix2)
{
    return MatrixMultiplyAdd(pOutValue, t, matrix1, matrix2);
}
void MatrixDivideWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix, float factor)
{
    return MatrixDivide(pOutValue, matrix, factor);
}
void MatrixDivideWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix, float factor)
{
    return MatrixDivide(pOutValue, matrix, factor);
}
bool MatrixInverseWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix)
{
    return MatrixInverse(pOutValue, matrix);
}
bool MatrixInverseWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix)
{
    return MatrixInverse(pOutValue, matrix);
}
void MatrixTransposeWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix)
{
    return MatrixTranspose(pOutValue, matrix);
}
void MatrixTransposeWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix)
{
    return MatrixTranspose(pOutValue, matrix);
}
bool MatrixInverseTransposeWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix)
{
    return MatrixInverseTranspose(pOutValue, matrix);
}
bool MatrixInverseTransposeWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix)
{
    return MatrixInverseTranspose(pOutValue, matrix);
}
void MatrixLookAtRightHandedWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& cameraPosition, const Vector3fType& target, const Vector3fType& up)
{
    return MatrixLookAtRightHanded(pOutValue, cameraPosition, target, up);
}
void MatrixLookAtRightHandedWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& cameraPosition, const Vector3fType& target, const Vector3fType& up)
{
    return MatrixLookAtRightHanded(pOutValue, cameraPosition, target, up);
}
void MatrixLookAtRightHandedWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& cameraPosition, const Vector3fType& target, float twistRadian)
{
    return MatrixLookAtRightHanded(pOutValue, cameraPosition, target, twistRadian);
}
void MatrixLookAtRightHandedWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& cameraPosition, const Vector3fType& target, float twistRadian)
{
    return MatrixLookAtRightHanded(pOutValue, cameraPosition, target, twistRadian);
}
void MatrixCameraRotateZxyWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& cameraPosition, const Vector3fType& rotationRadian)
{
    return MatrixCameraRotateZxy(pOutValue, cameraPosition, rotationRadian);
}
void MatrixCameraRotateZxyWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& cameraPosition, const Vector3fType& rotationRadian)
{
    return MatrixCameraRotateZxy(pOutValue, cameraPosition, rotationRadian);
}
void MatrixSetTranslateWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& translate)
{
    return MatrixSetTranslate(pOutValue, translate);
}
void MatrixSetTranslateWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& translate)
{
    return MatrixSetTranslate(pOutValue, translate);
}
void MatrixSetScaleWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& scale)
{
    return MatrixSetScale(pOutValue, scale);
}
void MatrixSetScaleWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& scale)
{
    return MatrixSetScale(pOutValue, scale);
}
void MatrixSetRotateWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector4fType& rotationQuaternion)
{
    return MatrixSetRotate(pOutValue, rotationQuaternion);
}
void MatrixSetRotateWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector4fType& rotationQuaternion)
{
    return MatrixSetRotate(pOutValue, rotationQuaternion);
}
void MatrixSetRotateXyzWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& rotationRadian)
{
    return MatrixSetRotateXyz(pOutValue, rotationRadian);
}
void MatrixSetRotateXyzWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& rotationRadian)
{
    return MatrixSetRotateXyz(pOutValue, rotationRadian);
}
void MatrixSetScaleRotateWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& scale, const Vector4fType& rotationQuaternion)
{
    return MatrixSetScaleRotate(pOutValue, scale, rotationQuaternion);
}
void MatrixSetScaleRotateWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& scale, const Vector4fType& rotationQuaternion)
{
    return MatrixSetScaleRotate(pOutValue, scale, rotationQuaternion);
}
void MatrixSetScaleRotateXyzWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& scale, const Vector3fType& rotationRadian)
{
    return MatrixSetScaleRotateXyz(pOutValue, scale, rotationRadian);
}
void MatrixSetScaleRotateXyzWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& scale, const Vector3fType& rotationRadian)
{
    return MatrixSetScaleRotateXyz(pOutValue, scale, rotationRadian);
}
void MatrixTextureProjectionPerspectiveOffCenterRightHandedWrapper(MatrixRowMajor4x3fType* pOutValue, float left, float right, float bottom, float top, float nearZ)
{
    return MatrixTextureProjectionPerspectiveOffCenterRightHanded(pOutValue, left, right, bottom, top, nearZ);
}
void MatrixTextureProjectionPerspectiveOffCenterRightHandedWrapper(MatrixColumnMajor4x3fType* pOutValue, float left, float right, float bottom, float top, float nearZ)
{
    return MatrixTextureProjectionPerspectiveOffCenterRightHanded(pOutValue, left, right, bottom, top, nearZ);
}
void MatrixTextureProjectionPerspectiveFieldOfViewRightHandedWrapper(MatrixRowMajor4x3fType* pOutValue, float fovyRadian, float aspect)
{
    return MatrixTextureProjectionPerspectiveFieldOfViewRightHanded(pOutValue, fovyRadian, aspect);
}
void MatrixTextureProjectionPerspectiveFieldOfViewRightHandedWrapper(MatrixColumnMajor4x3fType* pOutValue, float fovyRadian, float aspect)
{
    return MatrixTextureProjectionPerspectiveFieldOfViewRightHanded(pOutValue, fovyRadian, aspect);
}
void MatrixTextureProjectionOrthographicOffCenterRightHandedWrapper(MatrixRowMajor4x3fType* pOutValue, float left, float right, float bottom, float top)
{
    return MatrixTextureProjectionOrthographicOffCenterRightHanded(pOutValue, left, right, bottom, top);
}
void MatrixTextureProjectionOrthographicOffCenterRightHandedWrapper(MatrixColumnMajor4x3fType* pOutValue, float left, float right, float bottom, float top)
{
    return MatrixTextureProjectionOrthographicOffCenterRightHanded(pOutValue, left, right, bottom, top);
}
void MatrixLoadWrapper(MatrixRowMajor4x4fType* pOutValue, const FloatRowMajor4x4& source)
{
    return MatrixLoad(pOutValue, source);
}
void MatrixLoadWrapper(MatrixRowMajor4x4fType* pOutValue, const FloatColumnMajor4x4& source)
{
    return MatrixLoad(pOutValue, source);
}
void MatrixLoadWrapper(MatrixColumnMajor4x4fType* pOutValue, const FloatRowMajor4x4& source)
{
    return MatrixLoad(pOutValue, source);
}
void MatrixLoadWrapper(MatrixColumnMajor4x4fType* pOutValue, const FloatColumnMajor4x4& source)
{
    return MatrixLoad(pOutValue, source);
}
void MatrixStoreWrapper(FloatRowMajor4x4* pOutValue, const MatrixRowMajor4x4fType& source)
{
    return MatrixStore(pOutValue, source);
}
void MatrixStoreWrapper(FloatRowMajor4x4* pOutValue, const MatrixColumnMajor4x4fType& source)
{
    return MatrixStore(pOutValue, source);
}
void MatrixStoreWrapper(FloatColumnMajor4x4* pOutValue, const MatrixRowMajor4x4fType& source)
{
    return MatrixStore(pOutValue, source);
}
void MatrixStoreWrapper(FloatColumnMajor4x4* pOutValue, const MatrixColumnMajor4x4fType& source)
{
    return MatrixStore(pOutValue, source);
}
void MatrixConvertWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x4fType& source)
{
    return MatrixConvert(pOutValue, source);
}
void MatrixConvertWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x4fType& source)
{
    return MatrixConvert(pOutValue, source);
}
void MatrixSetWrapper(MatrixRowMajor4x4fType* pOutValue, float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33)
{
    return MatrixSet(pOutValue, m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
}
void MatrixSetWrapper(MatrixColumnMajor4x4fType* pOutValue, float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33)
{
    return MatrixSet(pOutValue, m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
}
void MatrixSetRowWrapper(MatrixRowMajor4x4fType* pOutValue, int index, const Vector4fType& vector)
{
    return MatrixSetRow(pOutValue, index, vector);
}
void MatrixSetRowWrapper(MatrixColumnMajor4x4fType* pOutValue, int index, const Vector4fType& vector)
{
    return MatrixSetRow(pOutValue, index, vector);
}
void MatrixSetRowsWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& row0, const Vector4fType& row1, const Vector4fType& row2, const Vector4fType& row3)
{
    return MatrixSetRows(pOutValue, row0, row1, row2, row3);
}
void MatrixSetRowsWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& row0, const Vector4fType& row1, const Vector4fType& row2, const Vector4fType& row3)
{
    return MatrixSetRows(pOutValue, row0, row1, row2, row3);
}
void MatrixGetRowWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x4fType& matrix, int index)
{
    return MatrixGetRow(pOutValue, matrix, index);
}
void MatrixGetRowWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix, int index)
{
    return MatrixGetRow(pOutValue, matrix, index);
}
void MatrixGetRowsWrapper(Vector4fType* pOutRow0, Vector4fType* pOutRow1, Vector4fType* pOutRow2, Vector4fType* pOutRow3, const MatrixRowMajor4x4fType& matrix)
{
    return MatrixGetRows(pOutRow0, pOutRow1, pOutRow2, pOutRow3, matrix);
}
void MatrixGetRowsWrapper(Vector4fType* pOutRow0, Vector4fType* pOutRow1, Vector4fType* pOutRow2, Vector4fType* pOutRow3, const MatrixColumnMajor4x4fType& matrix)
{
    return MatrixGetRows(pOutRow0, pOutRow1, pOutRow2, pOutRow3, matrix);
}
void MatrixSetColumnWrapper(MatrixRowMajor4x4fType* pOutValue, int index, const Vector4fType& vector)
{
    return MatrixSetColumn(pOutValue, index, vector);
}
void MatrixSetColumnWrapper(MatrixColumnMajor4x4fType* pOutValue, int index, const Vector4fType& vector)
{
    return MatrixSetColumn(pOutValue, index, vector);
}
void MatrixSetColumnsWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& column0, const Vector4fType& column1, const Vector4fType& column2, const Vector4fType& column3)
{
    return MatrixSetColumns(pOutValue, column0, column1, column2, column3);
}
void MatrixSetColumnsWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& column0, const Vector4fType& column1, const Vector4fType& column2, const Vector4fType& column3)
{
    return MatrixSetColumns(pOutValue, column0, column1, column2, column3);
}
void MatrixGetColumnWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x4fType& matrix, int index)
{
    return MatrixGetColumn(pOutValue, matrix, index);
}
void MatrixGetColumnWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix, int index)
{
    return MatrixGetColumn(pOutValue, matrix, index);
}
void MatrixGetColumnsWrapper(Vector4fType* pOutColumn0, Vector4fType* pOutColumn1, Vector4fType* pOutColumn2, Vector4fType* pOutColumn3, const MatrixRowMajor4x4fType& matrix)
{
    return MatrixGetColumns(pOutColumn0, pOutColumn1, pOutColumn2, pOutColumn3, matrix);
}
void MatrixGetColumnsWrapper(Vector4fType* pOutColumn0, Vector4fType* pOutColumn1, Vector4fType* pOutColumn2, Vector4fType* pOutColumn3, const MatrixColumnMajor4x4fType& matrix)
{
    return MatrixGetColumns(pOutColumn0, pOutColumn1, pOutColumn2, pOutColumn3, matrix);
}
void MatrixSetAxisXWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& vector)
{
    return MatrixSetAxisX(pOutValue, vector);
}
void MatrixSetAxisXWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& vector)
{
    return MatrixSetAxisX(pOutValue, vector);
}
void MatrixSetAxisYWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& vector)
{
    return MatrixSetAxisY(pOutValue, vector);
}
void MatrixSetAxisYWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& vector)
{
    return MatrixSetAxisY(pOutValue, vector);
}
void MatrixSetAxisZWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& vector)
{
    return MatrixSetAxisZ(pOutValue, vector);
}
void MatrixSetAxisZWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& vector)
{
    return MatrixSetAxisZ(pOutValue, vector);
}
void MatrixSetAxisWWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& vector)
{
    return MatrixSetAxisW(pOutValue, vector);
}
void MatrixSetAxisWWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& vector)
{
    return MatrixSetAxisW(pOutValue, vector);
}
void MatrixSetAxesWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& axisX, const Vector4fType& axisY, const Vector4fType& axisZ, const Vector4fType& axisW)
{
    return MatrixSetAxes(pOutValue, axisX, axisY, axisZ, axisW);
}
void MatrixSetAxesWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& axisX, const Vector4fType& axisY, const Vector4fType& axisZ, const Vector4fType& axisW)
{
    return MatrixSetAxes(pOutValue, axisX, axisY, axisZ, axisW);
}
void MatrixGetAxisXWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x4fType& matrix)
{
    return MatrixGetAxisX(pOutValue, matrix);
}
void MatrixGetAxisXWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix)
{
    return MatrixGetAxisX(pOutValue, matrix);
}
void MatrixGetAxisYWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x4fType& matrix)
{
    return MatrixGetAxisY(pOutValue, matrix);
}
void MatrixGetAxisYWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix)
{
    return MatrixGetAxisY(pOutValue, matrix);
}
void MatrixGetAxisZWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x4fType& matrix)
{
    return MatrixGetAxisZ(pOutValue, matrix);
}
void MatrixGetAxisZWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix)
{
    return MatrixGetAxisZ(pOutValue, matrix);
}
void MatrixGetAxisWWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x4fType& matrix)
{
    return MatrixGetAxisW(pOutValue, matrix);
}
void MatrixGetAxisWWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix)
{
    return MatrixGetAxisW(pOutValue, matrix);
}
void MatrixGetAxesWrapper(Vector4fType* pOutAxisX, Vector4fType* pOutAxisY, Vector4fType* pOutAxisZ, Vector4fType* pOutAxisW, const MatrixRowMajor4x4fType& matrix)
{
    return MatrixGetAxes(pOutAxisX, pOutAxisY, pOutAxisZ, pOutAxisW, matrix);
}
void MatrixGetAxesWrapper(Vector4fType* pOutAxisX, Vector4fType* pOutAxisY, Vector4fType* pOutAxisZ, Vector4fType* pOutAxisW, const MatrixColumnMajor4x4fType& matrix)
{
    return MatrixGetAxes(pOutAxisX, pOutAxisY, pOutAxisZ, pOutAxisW, matrix);
}
void MatrixZeroWrapper(MatrixRowMajor4x4fType* pOutValue)
{
    return MatrixZero(pOutValue);
}
void MatrixZeroWrapper(MatrixColumnMajor4x4fType* pOutValue)
{
    return MatrixZero(pOutValue);
}
void MatrixIdentityWrapper(MatrixRowMajor4x4fType* pOutValue)
{
    return MatrixIdentity(pOutValue);
}
void MatrixIdentityWrapper(MatrixColumnMajor4x4fType* pOutValue)
{
    return MatrixIdentity(pOutValue);
}
void MatrixAddWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix1, const MatrixRowMajor4x4fType& matrix2)
{
    return MatrixAdd(pOutValue, matrix1, matrix2);
}
void MatrixAddWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix1, const MatrixColumnMajor4x4fType& matrix2)
{
    return MatrixAdd(pOutValue, matrix1, matrix2);
}
void MatrixSubtractWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix1, const MatrixRowMajor4x4fType& matrix2)
{
    return MatrixSubtract(pOutValue, matrix1, matrix2);
}
void MatrixSubtractWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix1, const MatrixColumnMajor4x4fType& matrix2)
{
    return MatrixSubtract(pOutValue, matrix1, matrix2);
}
void MatrixMultiplyWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix, float factor)
{
    return MatrixMultiply(pOutValue, matrix, factor);
}
void MatrixMultiplyWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix, float factor)
{
    return MatrixMultiply(pOutValue, matrix, factor);
}
void MatrixMultiplyWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix1, const MatrixRowMajor4x3fType& matrix2)
{
    return MatrixMultiply(pOutValue, matrix1, matrix2);
}
void MatrixMultiplyWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix1, const MatrixColumnMajor4x3fType& matrix2)
{
    return MatrixMultiply(pOutValue, matrix1, matrix2);
}
void MatrixMultiplyWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix1, const MatrixRowMajor4x4fType& matrix2)
{
    return MatrixMultiply(pOutValue, matrix1, matrix2);
}
void MatrixMultiplyWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix1, const MatrixColumnMajor4x4fType& matrix2)
{
    return MatrixMultiply(pOutValue, matrix1, matrix2);
}
void MatrixDivideWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix, float factor)
{
    return MatrixDivide(pOutValue, matrix, factor);
}
void MatrixDivideWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix, float factor)
{
    return MatrixDivide(pOutValue, matrix, factor);
}
bool MatrixInverseWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix)
{
    return MatrixInverse(pOutValue, matrix);
}
bool MatrixInverseWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix)
{
    return MatrixInverse(pOutValue, matrix);
}
void MatrixTransposeWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix)
{
    return MatrixTranspose(pOutValue, matrix);
}
void MatrixTransposeWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix)
{
    return MatrixTranspose(pOutValue, matrix);
}
void MatrixPerspectiveOffCenterRightHandedWrapper(MatrixRowMajor4x4fType* pOutValue, float left, float right, float bottom, float top, float nearZ, float farZ)
{
    return MatrixPerspectiveOffCenterRightHanded(pOutValue, left, right, bottom, top, nearZ, farZ);
}
void MatrixPerspectiveOffCenterRightHandedWrapper(MatrixColumnMajor4x4fType* pOutValue, float left, float right, float bottom, float top, float nearZ, float farZ)
{
    return MatrixPerspectiveOffCenterRightHanded(pOutValue, left, right, bottom, top, nearZ, farZ);
}
void MatrixPerspectiveFieldOfViewRightHandedWrapper(MatrixRowMajor4x4fType* pOutValue, float fovyRadian, float aspect, float nearZ, float farZ)
{
    return MatrixPerspectiveFieldOfViewRightHanded(pOutValue, fovyRadian, aspect, nearZ, farZ);
}
void MatrixPerspectiveFieldOfViewRightHandedWrapper(MatrixColumnMajor4x4fType* pOutValue, float fovyRadian, float aspect, float nearZ, float farZ)
{
    return MatrixPerspectiveFieldOfViewRightHanded(pOutValue, fovyRadian, aspect, nearZ, farZ);
}
void MatrixOrthographicOffCenterRightHandedWrapper(MatrixRowMajor4x4fType* pOutValue, float left, float right, float bottom, float top, float nearZ, float farZ)
{
    return MatrixOrthographicOffCenterRightHanded(pOutValue, left, right, bottom, top, nearZ, farZ);
}
void MatrixOrthographicOffCenterRightHandedWrapper(MatrixColumnMajor4x4fType* pOutValue, float left, float right, float bottom, float top, float nearZ, float farZ)
{
    return MatrixOrthographicOffCenterRightHanded(pOutValue, left, right, bottom, top, nearZ, farZ);
}

}
}
}
