﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/util/util_Endian.h>

TEST( EndianTest, Swap )
{
    uint8_t u8( 0x12 );
    uint8_t r8( 0x12 );

    uint16_t u16( 0x1234 );
    uint16_t r16( 0x3412 );

    uint32_t u32( 0x12345678 );
    uint32_t r32( 0x78563412 );

    uint64_t u64( 0x123456789ABCDEF0 );
    uint64_t r64( 0xF0DEBC9A78563412 );

    uint8_t  dst8( u8 );
    uint16_t dst16( u16 );
    uint32_t dst32( u32 );
    uint64_t dst64( u64 );

    nn::util::SwapEndian( &dst8 );
    nn::util::SwapEndian( &dst16 );
    nn::util::SwapEndian( &dst32 );
    nn::util::SwapEndian( &dst64 );

    EXPECT_EQ( r8,  dst8 );
    EXPECT_EQ( r16, dst16 );
    EXPECT_EQ( r32, dst32 );
    EXPECT_EQ( r64, dst64 );

    EXPECT_EQ( r8,  nn::util::LoadEndianReversed( &u8  ) );
    EXPECT_EQ( r16, nn::util::LoadEndianReversed( &u16 ) );
    EXPECT_EQ( r32, nn::util::LoadEndianReversed( &u32 ) );
    EXPECT_EQ( r64, nn::util::LoadEndianReversed( &u64 ) );

    nn::util::StoreEndianReversed( &dst8,  u8  );
    nn::util::StoreEndianReversed( &dst16, u16 );
    nn::util::StoreEndianReversed( &dst32, u32 );
    nn::util::StoreEndianReversed( &dst64, u64 );

    EXPECT_EQ( r8,  dst8  );
    EXPECT_EQ( r16, dst16 );
    EXPECT_EQ( r32, dst32 );
    EXPECT_EQ( r64, dst64 );

    // float で Nan 扱いになる数値の反転をテストします
    uint32_t u = 0x460C9FFF;
    uint32_t uNan = 0xFF9F0C46; // float では Nan
    float f = *reinterpret_cast< float* >( &u );
    float fNan;
    nn::util::StoreEndianReversed( &fNan, f );
    uint32_t ufNan = *reinterpret_cast< uint32_t* >( &fNan );
    EXPECT_EQ( uNan, ufNan );

#if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
    EXPECT_EQ( u64, nn::util::LoadLittleEndian( &u64 ) );
    EXPECT_EQ( r64, nn::util::LoadBigEndian( &u64 ) );

    nn::util::StoreLittleEndian( &dst64, u64 );
    EXPECT_EQ( u64, dst64 );
    nn::util::StoreBigEndian( &dst64, u64 );
    EXPECT_EQ( r64, dst64 );
#else
    // Cafe 実機でのテスト対応用です。現在、テストは実効していません。
    EXPECT_EQ( r64, nn::util::LoadLittleEndian( &u64 ) );
    EXPECT_EQ( u64, nn::util::LoadBigEndian( &u64 ) );

    nn::util::StoreLittleEndian( &dst64, u64 );
    EXPECT_EQ( r64, dst64 );
    nn::util::StoreBigEndian( &dst64, u64 );
    EXPECT_EQ( u64, dst64 );
#endif

}
