﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/util/util_BytePtr.h>

namespace nn { namespace util {

TEST( BytePtrTest, BytePtr )
{
    static const int buf_size = 256;
    char buffer[ buf_size ];
    for ( int i = 0; i < buf_size; ++i )
    {
        buffer[ i ] = static_cast< char >( i );
    }

    BytePtr ptr( buffer );
    BytePtr advanced( buffer, 12 );

    ptr.Advance(12);
    EXPECT_EQ( 12, *ptr.Get< char >() );
    EXPECT_EQ( advanced.Get(), ptr.Get() );

    ptr.Reset( buffer );
    EXPECT_EQ( 0, *ptr.Get< char >() );

    ptr += 12;
    EXPECT_EQ( 12, *ptr.Get< char >() );
    EXPECT_EQ( 65, ptr.Distance( &buffer[ 77 ] ) );

    EXPECT_TRUE( ptr.IsAligned( 4 ) );

    ++ptr;
    EXPECT_EQ( 13, *ptr.Get< char >() );
    EXPECT_FALSE( ptr.IsAligned( 4 ) );

    ptr.AlignDown( 4 );
    EXPECT_EQ( 12, *ptr.Get< char >() );

    --ptr;
    EXPECT_EQ( 11, *ptr.Get< char >() );
    ptr.AlignUp( 4 );
    EXPECT_EQ( 12, *ptr.Get< char >() );
}

TEST( BytePtrTest, ConstBytePtr )
{
    static const int buf_size = 256;
    char buffer[ buf_size ];
    for ( int i = 0; i < buf_size; ++i )
    {
        buffer[ i ] = static_cast< char >( i );
    }

    ConstBytePtr ptr( buffer );
    ConstBytePtr advanced( buffer, 12 );

    ptr.Advance(12);
    EXPECT_EQ( 12, *ptr.Get< char >() );
    EXPECT_EQ( advanced.Get(), ptr.Get() );

    ptr.Reset( buffer );
    EXPECT_EQ( 0, *ptr.Get< char >() );

    ptr += 12;
    EXPECT_EQ( 12, *ptr.Get< char >() );
    EXPECT_EQ( 65, ptr.Distance( &buffer[ 77 ] ) );

    EXPECT_TRUE( ptr.IsAligned( 4 ) );

    ++ptr;
    EXPECT_EQ( 13, *ptr.Get< char >() );
    EXPECT_FALSE( ptr.IsAligned( 4 ) );

    ptr.AlignDown( 4 );
    EXPECT_EQ( 12, *ptr.Get< char >() );

    --ptr;
    EXPECT_EQ( 11, *ptr.Get< char >() );
    ptr.AlignUp( 4 );
    EXPECT_EQ( 12, *ptr.Get< char >() );
}

}} // namespace nn::util
