﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "UsbDiag_RootView.h"
#include "UsbDiag_UsbModel.h"

namespace nnt {
namespace usb {

RootView::RootView(const glv::Rect& rect) NN_NOEXCEPT
    : glv::View(rect)
    , m_Stage(glv::Rect(rect.width() - RootPaddingX * 2, rect.height() - RootGap - RootPaddingY * 2 - FooterHeight))
    , m_Footer(rect.width() - RootPaddingX * 2, FooterHeight)
    , m_Menu(rect)
    , m_Tuning(m_Stage)
    , m_Home(m_Stage)
    , m_Settings(m_Stage)
{
    // Last resort - never lose focus
    enable(glv::Property::HitTest     |
           glv::Property::Controllable);

    disable(glv::Property::DrawBack      |
            glv::Property::DrawBorder    |
            glv::Property::FocusHighlight);

    m_Stage.pos(glv::Place::TL, RootPaddingX, RootPaddingY);
    m_Footer.pos(glv::Place::BL, RootPaddingX, glv::Rect::height() - RootPaddingY);
    m_Menu.pos(glv::Place::TL, 0, 0);

    *this << m_Stage << m_Footer << m_Menu;

    m_Menu.AttachScene(m_Home);
    m_Menu.AttachScene(m_Tuning);
    m_Menu.AttachScene(m_Settings);
}

RootView::~RootView() NN_NOEXCEPT
{
    // nothing special
}

void
RootView::Start() NN_NOEXCEPT
{
    m_Home.Enter();
    m_Menu.Select(0);
}

bool
RootView::onEvent(glv::Event::t e, glv::GLV& g)
{
    bool bubble = true;

    switch (e)
    {
    case glv::Event::DebugPadDown:
        {
            const auto& pe = g.getDebugPadEvent();
            if (pe.IsButtonDown<glv::DebugPadEventType::Button::Start>() ||
                pe.IsButtonDown<glv::DebugPadEventType::Button::Select>() ) {
                g_Model.ToggleMenu();
                bubble = false;
            }
        }
        break;

    case glv::Event::BasicPadDown:
        {
            const auto& pe = g.getBasicPadEvent();
            if (pe.IsButtonDown<glv::BasicPadEventType::Button::Start>() ||
                pe.IsButtonDown<glv::BasicPadEventType::Button::Select>() ) {
                g_Model.ToggleMenu();
                bubble = false;
            }
        }
        break;

    default:
        break;
    }

    return bubble;
}

} // ~usb
} // ~nnt
