﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

namespace nnt {
namespace usb {

class HeartBeatView : public glv::View
{
public:
    explicit HeartBeatView(glv::space_t dia) NN_NOEXCEPT;

    virtual ~HeartBeatView() NN_NOEXCEPT;

    virtual const char *className() const { return "HeartBeatView"; };

    virtual void onDraw(glv::GLV& g) NN_NOEXCEPT;
    virtual void onAnimate(double dsec) NN_NOEXCEPT;

private:
    uint32_t m_Frame;
    float    m_Alpha;
};

} // ~usb
} // ~nnt
