﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_FormatString.h>

#include "UsbDiag_Theme.h"
#include "UsbDiag_EpView.h"
#include "UsbDiag_LabelView.h"

using namespace nn::usb;

namespace nnt {
namespace usb {

EpView::EpView(const Endpoint& endpoint) NN_NOEXCEPT
    : m_Endpoint(endpoint)
    , m_Detail("x-,<-,<<")
{
    disable(glv::Property::DrawBack   |
            glv::Property::DrawBorder |
            glv::Property::FocusToTop |
            glv::Property::FocusHighlight);

    CreateDetailView();

    const UsbEndpointDescriptor& desc = m_Endpoint.epDesc;
    const char *direction[] = {
        "Out", "In"
    };
    const char *xferType[] = {
        "Ctrl", "Iso", "Bulk", "Int"
    };

    nn::util::SNPrintf(
        m_String, sizeof(m_String),
        "Ep-%d / %s / %s",
        desc.bEndpointAddress & 0x0f,
        xferType[desc.bmAttributes & 0x03],
        direction[desc.bEndpointAddress >> 7]
    );

    LabelView *epLabel = new LabelView(m_String, EpPaddingX, EpPaddingY, m_Detail);

    this->add(epLabel).fit();

    epLabel->anchor(0, 0);
    epLabel->stretch(1, 1);

    width(EpWidth);
}

EpView::~EpView() NN_NOEXCEPT
{
    // nothing special
}

void EpView::CreateDetailView() NN_NOEXCEPT
{
    const UsbEndpointDescriptor& epDesc = m_Endpoint.epDesc;

    const char *title = "Endpoint Descriptor";
    const char *name =
        "bLength\n"
        "bDescriptorType\n"
        "bEndpointAddress\n"
        "bmAttributes\n"
        "wMaxPacketSize\n"
        "bInterval";

    nn::util::SNPrintf(
        m_String, sizeof(m_String),
        ": %02x\n"
        ": %02x\n"
        ": %02x\n"
        ": %02x\n"
        ": %04x\n"
        ": %02x",
        epDesc.bLength,
        epDesc.bDescriptorType,
        epDesc.bEndpointAddress,
        epDesc.bmAttributes,
        epDesc.wMaxPacketSize,
        epDesc.bInterval
    );

    m_Detail << new glv::Label(title) << new glv::Divider()
             << new glv::Label(name) << new glv::Label(m_String);

    m_Detail.arrange();

    m_Detail.disable(glv::Property::HitTest);
}

} // ~usb
} // ~nnt
