﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>

#include "Fx3MessageLogger.h"
#include "../Fx3Methods/Fx3.h"

namespace nnt {
namespace usb {
namespace hs {

    static NN_ALIGNAS(4096) char g_Fx3StringBuf[128] = { 0 };

    // テストケース開始前に呼ばれます
    void Fx3MessageLogger::OnTestCaseStart(const ::testing::TestCase& test_case)
    {
        if (IsFx3Initialized())
        {
            sprintf(g_Fx3StringBuf, "\n**[FX3] Test Suite started: %s", test_case.name());
            Fx3PrintString((uint8_t*)g_Fx3StringBuf, sizeof(g_Fx3StringBuf));
            // FX3_LOG("Fx3 is connected. sent string: %s\n", g_Fx3StringBuf);
            memset(g_Fx3StringBuf, 0, sizeof(g_Fx3StringBuf));

            // Wait for fx3 to print Test Case string
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(500));
        }
    }

    // テスト開始前に呼ばれます
    void Fx3MessageLogger::OnTestStart(const ::testing::TestInfo& test_info)
    {
        if (IsFx3Initialized())
        {
            sprintf(g_Fx3StringBuf, "\n**[FX3] Test started: %s/%s", test_info.test_case_name(), test_info.name());
            Fx3PrintString((uint8_t*)g_Fx3StringBuf, sizeof(g_Fx3StringBuf));
            // FX3_LOG("Fx3 is connected. sent string: %s\n", g_Fx3StringBuf);

            // Wait for fx3 to print Test Case string
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(500));
        }
    }

    // テスト終了後に呼ばれます
    void Fx3MessageLogger::OnTestEnd(const ::testing::TestInfo& test_info)
    {
        if (IsFx3Initialized())
        {
            if (test_info.result()->Failed())
            {
                sprintf(g_Fx3StringBuf, "\n**[FX3] Test FAILED: %s/%s duration=%d",
                    test_info.test_case_name(), test_info.name(), static_cast<uint32_t>(test_info.result()->elapsed_time()));
                Fx3PrintString((uint8_t*)g_Fx3StringBuf, sizeof(g_Fx3StringBuf));
                // FX3_LOG("Fx3 is connected. sent string: %s\n", g_Fx3StringBuf);
            }

            sprintf(g_Fx3StringBuf, "\n**[FX3] Test Finished: %s/%s duration=%d",
                test_info.test_case_name(), test_info.name(), static_cast<uint32_t>(test_info.result()->elapsed_time()));
            Fx3PrintString((uint8_t*)g_Fx3StringBuf, sizeof(g_Fx3StringBuf));
            // FX3_LOG("Fx3 is connected. sent string: %s\n", g_Fx3StringBuf);


            // Wait for fx3 to print Test Case string
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(500));
        }
    }

    // テストケース終了後に呼ばれます
    void Fx3MessageLogger::OnTestCaseEnd(const ::testing::TestCase& test_case)
    {
        if (IsFx3Initialized())
        {
            sprintf(g_Fx3StringBuf, "\n**[FX3] Test Suite Finished: %s duration=%d",
                test_case.name(), static_cast<uint32_t>(test_case.elapsed_time()));
            Fx3PrintString((uint8_t*)g_Fx3StringBuf, sizeof(g_Fx3StringBuf));
            // FX3_LOG("Fx3 is connected. sent string: %s\n", g_Fx3StringBuf);

            // Wait for fx3 to print Test Case string
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(500));
        }
    }
} // hs
} // usb
} // nnt
