﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Includes.h"

//////////////////////////////////////////////////////////////////////////////
void Depop::Initialize()
{
    m_LastGoodSample    = 0;
    m_State             = DepopState::DepopState0;
}


//////////////////////////////////////////////////////////////////////////////
void Depop::Finalize()
{
}


//////////////////////////////////////////////////////////////////////////////
int16_t * Depop::ProcessFrame(void *pSamples, bool depop)
{
    int16_t *p = reinterpret_cast<int16_t*>(pSamples);

    if (depop)  // depop this frame
    {
        if (m_State == DepopState::DepopState1)
        {
            RampDcOffsetDown(p);
            memset(pSamples, 0, SamplesPerFrameCount * sizeof(int16_t));

            m_State = DepopState::DepopState0;
        }
        else
        {
            pSamples = NULL; // Mix will not sum a NULL buffer, same as silence :)
        }

        m_LastGoodSample = 0;
    }
    else // this is a good frame
    {
        if (m_State == DepopState::DepopState0)
        {
            RampVolumeUp(p);
            m_State = DepopState::DepopState1;
        }

        m_LastGoodSample = p[SamplesPerFrameCount - 1];
    }

    return p;
}


//////////////////////////////////////////////////////////////////////////////
void Depop::RampDcOffsetDown(int16_t *pSamples)
{
    if (m_LastGoodSample > 0)
    {
        for (uint32_t i = 0; i < SamplesPerFrameCount; i++)
        {
            if (m_LastGoodSample > DepopRampDownDelta)
            {
                m_LastGoodSample -= DepopRampDownDelta;
            }
            else
            {
                m_LastGoodSample = 0;
            }

            *pSamples++ = m_LastGoodSample;
        }

        return;
    }

    if (m_LastGoodSample < 0)
    {
        for (uint32_t i = 0; i < SamplesPerFrameCount; i++)
        {
            if (m_LastGoodSample < -DepopRampDownDelta)
            {
                m_LastGoodSample += DepopRampDownDelta;
            }
            else
            {
                m_LastGoodSample = 0;
            }

            *pSamples++ = m_LastGoodSample;
        }

        return;
    }
}


//////////////////////////////////////////////////////////////////////////////
void Depop::RampVolumeUp(int16_t *pSamples)
{
    int32_t volume = 0;

    for (uint32_t i = 0; i < SamplesPerFrameCount; i++)
    {
        int32_t a = *pSamples * volume;

        volume += DepopRampUpDelta;

        *pSamples++ = static_cast<int16_t>(a / 0xffff);
    }
}

