﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/ts.h>
struct LocationList
{
    nn::ts::Location  location;
    char              name[32];
};

const LocationList LocationtTable[] = {
//        {nn::ts::Location_SocCpu, "Location_SocCpu"},
//        {nn::ts::Location_SocGpu, "Location_SocGpu"},
//        {nn::ts::Location_SocPll, "Location_SocPll"},
//        {nn::ts::Location_SocMem, "Location_SocMem"},
        {nn::ts::Location_ThermalSensorInternal, "Location_ThermalSensorInternal"},
        {nn::ts::Location_ThermalSensorExternal, "Location_ThermalSensorExternal"},
//        {nn::ts::Location_Battery, "Location_Battery"},
};

const int NumberOfLocation      = sizeof(LocationtTable) / sizeof(LocationtTable[0]);
const int MeasurementInterbalMs = 1000;
const int MeasurementLoopCount  = 10;
