﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace UpdaterTest
{
    class TargetLogTester
    {
        private string m_UartLog = null;
        private string m_Log = null;
        private string m_BuildType = null;

        public TargetLogTester(Tuple<string, string> logs, string buildType)
        {
            m_Log = logs.Item1;
            m_UartLog = logs.Item2;
            m_BuildType = buildType;
        }
        private bool FindSequencial(string log, string[] expects)
        {
            var index = 0;
            foreach(var expect in expects)
            {
                var found = log.IndexOf(expect, index);
                if(found < index)
                {
                    // 見つからない場合
                    return false;
                }
                index = found;
            }
            return true;
        }
        private bool NotContains(string log, string[] unexpects)
        {
            foreach(var unexpect in unexpects)
            {
                var index = log.IndexOf(unexpect);
                if(index != -1)
                {
                    return false;
                }
            }
            return true;
        }

        public TargetLogTester ExpectInLog(params string[] expects)
        {
            Assert.IsTrue(FindSequencial(m_Log, expects));
            return this;
        }
        public TargetLogTester NotExpectInLog(params string[] unexpects)
        {
            Assert.IsTrue(NotContains(m_Log, unexpects));
            return this;
        }

        public TargetLogTester ExpectInUartLog(params string[] expects)
        {
            if (m_BuildType == "Develop")
            {
                // UART は Develop でないと見れない
                Assert.IsTrue(FindSequencial(m_UartLog, expects));
            }
            return this;
        }
        public TargetLogTester NotExpectInUartLog(params string[] unexpects)
        {
            if (m_BuildType == "Develop")
            {
                // UART は Develop でないと見れない
                Assert.IsTrue(NotContains(m_UartLog, unexpects));
            }
            return this;
        }
        public TargetLogTester ExpectInLog(Func<string, bool> f)
        {
            Assert.IsTrue(f(m_Log));
            return this;
        }
        public TargetLogTester ExpectInUartLog(Func<string, bool> f)
        {
            Assert.IsTrue(f(m_UartLog));
            return this;
        }
    }
}
