﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundationGeneric.FileFormats.NintendoSdkBinary
{
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using NintendoWare.SoundFoundation.Binarization;
    using System;
    using System.IO;
    using System.Text;

    [TestClass]
    public class BinaryBlockTest
    {
        [TestMethod]
        public void WriteTestBinary()
        {
            var file = new TestFile();
            file.Header.ResourceAddressSize = 32;

            var block1 = new TestBlock1();
            block1.Body.Content = "test1";
            file.Blocks.Add(block1);

            var block2 = new TestBlock2();
            block2.Body.Content = "test2";
            file.Blocks.Add(block2);

            var buffer = new byte[256];

            using (var writer = new BinaryWriter(new MemoryStream(buffer), Encoding.UTF8, false))
            {
                DomElement fileElement = new DomBuilder().Build(file);
                new DomWriter(writer).Run(new DomObjectWriter(), fileElement);
            }

            // NOTE : とりあえず、例外が起きないことを確認する
        }

        internal class TestFile : BinaryFileRoot
        {
            public TestFile()
                : base("TESTTEST", new Version("1.2.3"))
            {
            }
        }

        internal class TestBlock1 : BinaryBlock<TestBody>
        {
            public TestBlock1()
                : base("TES1")
            {
                this.Body = new TestBody();
            }
        }

        internal class TestBlock2 : BinaryBlock<TestBody>
        {
            public TestBlock2()
                : base("TES2")
            {
                this.Body = new TestBody();
            }
        }

        internal class TestBody
        {
            public string Content { get; set; }
        }
    }
}
