﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.ServiceFramework;

namespace Nintendo.ServiceFrameworkTest
{
    [TestClass]
    public class SfEntityTest
    {
        #region TestUnknownEntity

        private class UnknownEntity1
        {
        }

        private void AssertUnknownEntity<T>()
        {
            AssertionUtility.AssertException<UnknownEntityException>(
                () => typeof(T).GetSfEntity(),
                e => AssertionUtility.AssertUserErrorException(e, @"SF-UnknownEntity"));
        }

        [TestMethod]
        public void TestUnknownEntity()
        {
            AssertUnknownEntity<string>();
            AssertUnknownEntity<UnknownEntity1>();
        }

        #endregion
    }
}
