﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Nintendo.ServiceFrameworkTest.CppCode
{
    [TestClass]
    public class NnResultCppCodeEmitterTest
    {
        [TestMethod]
        public void TestGetCppTypeString()
        {
            Assert.AreEqual(@"::nn::Result", typeof(nn.Result).GetSfEntity().GetCppTypeString(false));
            Assert.AreEqual(@"nn::Result", typeof(nn.Result).GetSfEntity().GetCppTypeString(true));
        }

        [TestMethod]
        public void TestGetParameterString()
        {
            Assert.AreEqual(@"::nn::Result foo", typeof(nn.Result).GetSfEntity().GetParameterString(@"foo", InOutType.In, false));
            Assert.AreEqual(@"nn::Result foo", typeof(nn.Result).GetSfEntity().GetParameterString(@"foo", InOutType.In, true));
            Assert.AreEqual(@"::nn::sf::Out<::nn::Result> foo", typeof(nn.Result).GetSfEntity().GetParameterString(@"foo", InOutType.Out, false));
            Assert.AreEqual(@"nn::sf::Out<nn::Result> foo", typeof(nn.Result).GetSfEntity().GetParameterString(@"foo", InOutType.Out, true));
        }

        [TestMethod]
        public void TestGetStructPlacedString()
        {
            Assert.AreEqual(@"::nn::Result foo", typeof(nn.Result).GetSfEntity().GetStructPlacedString(@"foo", false));
            Assert.AreEqual(@"nn::Result foo", typeof(nn.Result).GetSfEntity().GetStructPlacedString(@"foo", true));
        }

        [TestMethod]
        public void TestGetExternalIncludes()
        {
            AssertionUtility.AssertAreSetEqual(new[] { @"<nn/nn_Result.h>" }, typeof(nn.Result).GetSfEntity().GetExternalIncludes());
        }

        [TestMethod]
        public void TestGetAdditionalIncludes()
        {
            AssertionUtility.AssertAreSetEqual(Enumerable.Empty<string>(), typeof(nn.Result).GetSfEntity().GetAdditionalIncludes());
        }

        [TestMethod]
        public void TestEmitForwardDeclarationCode()
        {
            GenerateTestUtility.AssertGenerateEmpty(typeof(nn.Result).GetSfEntity().EmitForwardDeclarationCode);
        }

        [TestMethod]
        public void TestEmitDefinitionCode()
        {
            GenerateTestUtility.AssertGenerateEmpty(typeof(nn.Result).GetSfEntity().EmitDefinitionCode);
        }

        [TestMethod]
        public void TestEmitReferenceCheckCode()
        {
            GenerateTestUtility.AssertGenerateEmpty(typeof(nn.Result).GetSfEntity().EmitReferenceCheckCode);
        }
    }
}
