﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.ComponentModel.Composition;
using System.ComponentModel.Composition.Hosting;
using System.Collections.Generic;
using Nintendo.ControlTarget;

namespace PhidgetTest
{
    [Export(typeof(IResetController))]
    [ExportMetadata("ResetType", "HandOperation")]
    [ExportMetadata("Priority", 100)]
    public class ManualResetController : IResetController
    {
        void IResetController.Reset()
        {
            throw new NotImplementedException();
        }
    }

    [TestClass]
    public class PhidgetTest
    {
        private CompositionContainer Container;

        [ImportMany]
        private IEnumerable<Lazy<IResetController, IResetControllerData>> ResetControllers = null;

        [TestMethod]
        public void TestPlugin()
        {
            var catalog = new AggregateCatalog();
            catalog.Catalogs.Add(new AssemblyCatalog(typeof(PhidgetTest).Assembly));
            catalog.Catalogs.Add(new DirectoryCatalog(System.IO.Path.GetDirectoryName(typeof(PhidgetTest).Assembly.Location)));
            Container = new CompositionContainer(catalog);
            Container.ComposeParts(this);

            var sortedResetControllers = new List<Lazy<IResetController, IResetControllerData>>(ResetControllers);
            sortedResetControllers.Sort((a, b) => { return a.Metadata.Priority - b.Metadata.Priority; });

            var resetController = sortedResetControllers[0];
            Console.WriteLine(resetController.Metadata.ResetType);
        }

        [TestMethod]
        public void TestResetController()
        {
            var aggregated = new Nintendo.ControlTarget.ResetController();

            aggregated.Reset();
        }

        [TestMethod]
        public void TestForceRecovery()
        {
            var aggregated = new Nintendo.ControlTarget.GenericController();

            aggregated.Do("ForceRecovery");
        }
    }
}
