﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.ControlTarget.Tmapi;

namespace ControlTargetManagerPluginTest
{
    [TestClass]
    public class ControlTargetManagerPluginTest
    {
        [TestMethod]
        public void TestBasic()
        {
            var acc = new TargetManagerAccessor();

            Console.WriteLine("TargetCount: {0}", acc.GetTargetCount());

            if (0 < acc.GetTargetCount())
            {
                var target = acc.GetDefaultTarget();
                Console.WriteLine("Target.IsConnected: {0}", target.IsConnected());

                target.Disconnect();
                Console.WriteLine("Target.IsConnected: {0}", target.IsConnected());

                target.Connect();
                Console.WriteLine("Target.IsConnected: {0}", target.IsConnected());
            }
        }

        [TestMethod]
        public void TestDetectTargets()
        {
            var acc = new TargetManagerAccessor();

            acc.UnregisterAllTargets();

            Assert.AreEqual(acc.GetDefaultTargetHandle(), null);

            var targets = acc.DetectTargets(TimeSpan.FromSeconds(10));
            Console.WriteLine("TargetCount: {0}", targets.Count);

            foreach (var target in targets)
            {
                Console.Write(target.ToString());
            }

            var registeredTargets = acc.ListTargets();
            Console.WriteLine("TargetCount: {0}", registeredTargets.Count);

            foreach (var target in registeredTargets)
            {
                Console.Write(target.ToString());
            }

            acc.UnregisterAllTargets();
        }
    }
}
