﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.MakeVisualStudioProject.Converter;

namespace Nintendo.MakeVisualStudioProjectTest.Converter
{
    internal class TestOptionDefinitions
    {
        public static readonly IEnumerable<OptionDefinition> Definitions = new OptionDefinition[]
        {
            new OptionDefinition("/a", "aName", "aValue"),

            new OptionDefinition("/b1", "b1Name", "b1Value", true, requiresArg: false),
            new OptionDefinition("/b2", "b2Name", "b2Value", true, requiresArg: true),

            new OptionDefinition("/c1", "c1Name", "c1Value", true, requiresArg: false, argName: "c1ArgName"),
            new OptionDefinition("/c2", "c2Name", "c2Value", true, requiresArg: true,  argName: "c2ArgName"),

            new OptionDefinition("/d1", "d1Name", "d1Value", true, requiresArg: false, argSeparator: ";"),
            new OptionDefinition("/d2", "d2Name", "d2Value", true, requiresArg: true,  argSeparator: ";"),

            new OptionDefinition("/e1", "e1Name", "e1Value", true, requiresArg: false, argName: "e1ArgName", argSeparator: ";"),
            new OptionDefinition("/e2", "e2Name", "e2Value", true, requiresArg: true,  argName: "e2ArgName", argSeparator: ";"),

            new OptionDefinition("/f1 ", "f1Name", "f1Value", true, requiresArg: true),
            new OptionDefinition("/f2 ", "f2Name", "f2Value", true, requiresArg: true, argSeparator: ";"),

            new OptionDefinition("/g", "gName", "gValue", true, requiresArg: false, argName: "gArgName"),
            new OptionDefinition(null, "gArgName", null, true, requiresArg: true, separator: ":"),
        };
    }

    internal class TestOptionStringConverter : OptionStringConverter
    {
        public TestOptionStringConverter()
        {
            this.SwitchPrefix = "/";
            this.OptionDefinitions = TestOptionDefinitions.Definitions;
        }
    }

    internal class TestItemMetadataConverter : ItemMetadataConverter
    {
        public TestItemMetadataConverter()
        {
            this.OptionDefinitions = TestOptionDefinitions.Definitions;
        }
    }
}
