﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeNrrTest
{
    public static class NrrFormat
    {
        public const uint Signature = 0x3052524E; // "NRR0"
        public const int HashSize = 0x20; // "NRR0"

        public const int SignatureOffset = 0x0;
        public const int Reserved0x4 = 0x4;
        public const int CertOffset = 0x10;
        public const int SignOffset = 0x230;
        public const int ApplicationIdOffset = 0x330;
        public const int SizeOffset = 0x338;
        public const int Reserved0x33C = 0x33c;
        public const int HashAddressOffset = 0x340;
        public const int NumHashOffset = 0x344;
        public const int Reserved0x348 = 0x348;
    }

    public static class NrrCertificationFormat
    {
        public const int ApplicationMaskOffset = 0x0;
        public const int ApplicationIdPatternOffset = 0x8;
        public const int Reserved0x10 = 0x10;
        public const int PublicKeyOffset = 0x20;
        public const int SignOffset = 0x120;
    }

}
