﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using LECore.Structures;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Reflection;

namespace LECoreTest
{
    /// <summary>
    /// グループに関するテスト項目
    /// </summary>
    [TestClass]
    public class GroupTest
    {
        #region グループの「作成」、「編集」、「削除」ができる

        /// <summary>
        /// グループの「作成」、「編集」、「削除」ができる
        /// </summary>
        [TestMethod]
        public void GroupTest_CreateEditAndDelete()
        {
            // 準備
            {
                TestUtility.InitializeTest(MethodBase.GetCurrentMethod());
            }

            // テスト
            {
                // レイアウトを新規作成
                ISubScene newSubScene = TestUtility.CreateLayout();

                // ヌルペインを追加
                IPane nullPane1 = TestUtility.AddNullPane(newSubScene, "NullPane1");
                IPane nullPane2 = TestUtility.AddNullPane(newSubScene, "NullPane2");

                // ペインからグループを作成
                ILEGroup group = TestUtility.CreateGroup(nullPane1, "newGroup");

                // 比較
                Assert.AreEqual(group.GrouprName, "newGroup");
                Assert.AreEqual(group.ContainsPaneName("NullPane1"), true);

                // グループにペインを追加
                TestUtility.AddPaneToGroup(newSubScene, group, nullPane2);

                // 比較
                Assert.AreEqual(group.ContainsPaneName("NullPane2"), true);

                // グループからペインを削除
                TestUtility.RemovePaneFromGroup(newSubScene, group, nullPane1);

                // 比較
                Assert.AreEqual(group.ContainsPaneName("NullPane1"), false);
                Assert.AreEqual(group.ContainsPaneName("NullPane2"), true);

                // レイアウトを閉じる
                TestUtility.CloseLayout(newSubScene);
            }

            // 後処理
            {
                TestUtility.FinalizeTest(MethodBase.GetCurrentMethod());
            }
        }

        #endregion
    }
}
