﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Nintendo.HtcTools.HtcfsLibrary;

namespace Nintendo.HtcTools.HtcfsLibraryTest
{
    internal class TestHeaderFactory
    {
        public short Version { get; set; } = Constants.MaxVersion;

        public Header MakeRequestHeader(PacketType packetType, long bodySize)
        {
            return MakeRequestHeader(packetType, bodySize, 0, 0, 0, 0, 0);
        }

        public Header MakeRequestHeader(PacketType packetType, long bodySize, long param0)
        {
            return MakeRequestHeader(packetType, bodySize, param0, 0, 0, 0, 0);
        }

        public Header MakeRequestHeader(PacketType packetType, long bodySize, long param0, long param1)
        {
            return MakeRequestHeader(packetType, bodySize, param0, param1, 0, 0, 0);
        }

        public Header MakeRequestHeader(PacketType packetType, long bodySize, long param0, long param1, long param2)
        {
            return MakeRequestHeader(packetType, bodySize, param0, param1, param2, 0, 0);
        }

        public Header MakeRequestHeader(PacketType packetType, long bodySize, long param0, long param1, long param2, long param3)
        {
            return MakeRequestHeader(packetType, bodySize, param0, param1, param2, param3, 0);
        }

        public Header MakeRequestHeader(PacketType packetType, long bodySize, long param0, long param1, long param2, long param3, long param4)
        {
            return new Header()
            {
                Protocol = Constants.Protocol,
                Version = Version,
                PacketCategory = PacketCategory.Request,
                PacketType = packetType,
                BodySize = bodySize,
                Param0 = param0,
                Param1 = param1,
                Param2 = param2,
                Param3 = param3,
                Param4 = param4,
            };
        }
    }
}
