﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace Nintendo.Hid
{
    public class DebugPadAnalogStickState
    {
        internal DebugPadAnalogStickState(short x, short y)
        {
            this.X = x;
            this.Y = y;
        }

        public short X { get; private set; }

        public short Y { get; private set; }

        public override int GetHashCode()
        {
            return (this.X << 16) + this.Y;
        }

        public override bool Equals(object obj)
        {
            var other = obj as DebugPadAnalogStickState;

            if (other == null)
            {
                return false;
            }
            else
            {
                return (this.X == other.X) && (this.Y == other.Y);
            }
        }
    }
}
