﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Linq;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Diagnostics;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using GitExternalStorage;
using System.Security.Cryptography;
using TestUtility;
using GitExternalStorage.Configs;
using GitExternalStorage.Commands;
using GitExternalStorage.Transports;
using GitExternalStorage.Consoles;
using GitExternalStorage.Git;
using Microsoft.Win32;
using System.Text.RegularExpressions;

namespace GitExternalStorageTest
{
    [TestClass]
    public class UnitTest
    {
        public TestContext TestContext { get; set; }

        private static string oldPathVariable;

        [AssemblyInitialize]
        public static void AssemblyInitialize(TestContext context)
        {
            var gitPath = Path.Combine(GetGitInstallLocation(), "cmd");
            var currentPathVariable = Environment.GetEnvironmentVariable("Path");
            var newPathVariable = string.Format("{0};{1}", currentPathVariable, gitPath);
            Environment.SetEnvironmentVariable("Path", newPathVariable, EnvironmentVariableTarget.Process);

            oldPathVariable = currentPathVariable;
        }

        /// <summary>
        /// レジストリから git のインストールディレクトリを取得します。
        /// </summary>
        public static string GetGitInstallLocation()
        {
            string relativePathToKey = @"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Git_is1";
            string valueName = "InstallLocation";

            return
                GetValueFromRegistryKey(RegistryHive.LocalMachine, RegistryView.Registry64, relativePathToKey, valueName) as string
                ?? GetValueFromRegistryKey(RegistryHive.CurrentUser, RegistryView.Registry64, relativePathToKey, valueName) as string
                ?? GetValueFromRegistryKey(RegistryHive.LocalMachine, RegistryView.Registry32, relativePathToKey, valueName) as string
                ?? GetValueFromRegistryKey(RegistryHive.CurrentUser, RegistryView.Registry32, relativePathToKey, valueName) as string;
        }

        private static object GetValueFromRegistryKey(RegistryHive hive, RegistryView view, string subKeyName, string valueName)
        {
            using (var baseKey = RegistryKey.OpenBaseKey(hive, view))
            {
                using (var subKey = baseKey?.OpenSubKey(subKeyName))
                {
                    return subKey?.GetValue(valueName);
                }
            }
        }

        [AssemblyCleanup]
        public static void AssemblyCleanup()
        {
            Environment.SetEnvironmentVariable("Path", oldPathVariable, EnvironmentVariableTarget.Process);
        }

        [TestMethod]
        public void GitCommandTest()
        {
            var output = ProcessUtility.GetProcessOutput("git", "--version");
            StringAssert.Matches(output, new Regex("^git version .*windows.*$"));
        }
    }
}
