﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using GitExternalStorage.Consoles;

namespace GitExternalStorageTest
{
    public class FileCommandConsole : CommandConsoleBase
    {
        private string inputFilePath;
        private string outputFilePath;
        private string errorFilePath;

        public FileCommandConsole(string inputFilePath, string outputFilePath, string errorFilePath)
        {
            this.inputFilePath = inputFilePath;
            this.outputFilePath = outputFilePath;
            this.errorFilePath = errorFilePath;
        }

        protected override TextReader OpenInputReader()
        {
            return new StreamReader(this.inputFilePath);
        }

        protected override TextWriter OpenOutputWriter()
        {
            return new StreamWriter(this.outputFilePath);
        }

        protected override TextWriter OpenErrorWriter()
        {
            return new StreamWriter(this.errorFilePath);
        }

        public override Stream OpenInputStream()
        {
            return new FileStream(this.inputFilePath, FileMode.OpenOrCreate, FileAccess.Read);
        }

        public override Stream OpenOutputStream()
        {
            return new FileStream(this.outputFilePath, FileMode.OpenOrCreate, FileAccess.Write);
        }

        public override Stream OpenErrorStream()
        {
            return new FileStream(this.errorFilePath, FileMode.OpenOrCreate, FileAccess.Write);
        }
    }
}
