﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Primitives;
using EffectMaker.UILogic.TypeSerializers;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Test.EffectMaker.UILogic.UnitTests
{
    /// <summary>
    /// Test class for IXmlTypeSerializer.
    /// </summary>
    [TestClass]
    public class XmlTypeSerializerUnitTests
    {
        /// <summary>
        /// Test method.
        /// </summary>
        [TestMethod]
        public void TestLanguagePrimitiveXmlTypeSerializer01()
        {
            var types = new Type[]
            {
                typeof(bool),
                typeof(byte),
                typeof(sbyte),
                typeof(char),
                typeof(short),
                typeof(ushort),
                typeof(int),
                typeof(uint),
                typeof(long),
                typeof(ulong),
                typeof(decimal),
                typeof(float),
                typeof(double),
                typeof(string),
            };

            IXmlTypeSerializer s = new LanguagePrimitiveXmlTypeSerializer();

            foreach (Type t in types)
            {
                Assert.IsTrue(s.IsSupportedType(t));
            }
        }

        /// <summary>
        /// Test method.
        /// </summary>
        [TestMethod]
        public void TestLanguagePrimitiveXmlTypeSerializer02()
        {
            IXmlTypeSerializer s = new LanguagePrimitiveXmlTypeSerializer();

            bool v = true;

            XElement x = s.Serialize("test", v);

            Assert.AreEqual(x.ToString(SaveOptions.DisableFormatting), "<lp name=\"test\" type=\"System.Boolean\" value=\"true\" />");
        }

        /// <summary>
        /// Test method.
        /// </summary>
        [TestMethod]
        public void TestLanguagePrimitiveXmlTypeSerializer03()
        {
            IXmlTypeSerializer s = new LanguagePrimitiveXmlTypeSerializer();

            int v = 0;

            XElement x = s.Serialize("test", v);

            Assert.AreEqual(x.ToString(SaveOptions.DisableFormatting), "<lp name=\"test\" type=\"System.Int32\" value=\"0\" />");
        }

        /// <summary>
        /// Test method.
        /// </summary>
        [TestMethod]
        public void TestLanguagePrimitiveXmlTypeSerializer04()
        {
            IXmlTypeSerializer s = new LanguagePrimitiveXmlTypeSerializer();

            int v = 1;

            XElement x = s.Serialize("test", v);

            Assert.AreEqual(x.ToString(SaveOptions.DisableFormatting), "<lp name=\"test\" type=\"System.Int32\" value=\"1\" />");
        }

        /// <summary>
        /// Test method.
        /// </summary>
        [TestMethod]
        public void TestLanguagePrimitiveXmlTypeSerializer05()
        {
            IXmlTypeSerializer s = new LanguagePrimitiveXmlTypeSerializer();

            int v = 15;

            XElement x = s.Serialize("test", v);

            Assert.AreEqual(x.ToString(SaveOptions.DisableFormatting), "<lp name=\"test\" type=\"System.Int32\" value=\"15\" />");
        }

        /// <summary>
        /// Test method.
        /// </summary>
        [TestMethod]
        public void TestLanguagePrimitiveXmlTypeSerializer06()
        {
            IXmlTypeSerializer s = new LanguagePrimitiveXmlTypeSerializer();

            ushort v = 1;

            XElement x = s.Serialize("test", v);

            Assert.AreEqual(x.ToString(SaveOptions.DisableFormatting), "<lp name=\"test\" type=\"System.UInt16\" value=\"1\" />");
        }

        /// <summary>
        /// Test method.
        /// </summary>
        [TestMethod]
        public void TestLanguagePrimitiveXmlTypeSerializer07()
        {
            IXmlTypeSerializer s = new LanguagePrimitiveXmlTypeSerializer();

            float v = 1;

            XElement x = s.Serialize("test", v);

            Assert.AreEqual(x.ToString(SaveOptions.DisableFormatting), "<lp name=\"test\" type=\"System.Single\" value=\"1\" />");
        }

        /// <summary>
        /// Test method.
        /// </summary>
        [TestMethod]
        public void TestLanguagePrimitiveXmlTypeSerializer08()
        {
            IXmlTypeSerializer s = new LanguagePrimitiveXmlTypeSerializer();

            int v = 1;
            string name;
            object value;

            XElement x = s.Serialize("test", v);
            s.Deserialize(x, out name, out value);

            Assert.AreEqual<int>((int)value, 1);
            Assert.AreEqual(name, "test");
        }

        /// <summary>
        /// Test method.
        /// </summary>
        [TestMethod]
        public void TestLanguagePrimitiveXmlTypeSerializer09()
        {
            IXmlTypeSerializer s = new LanguagePrimitiveXmlTypeSerializer();

            bool v = false;
            string name;
            object value;

            XElement x = s.Serialize("test", v);
            s.Deserialize(x, out name, out value);

            Assert.AreEqual<bool>((bool)value, false);
            Assert.AreEqual(name, "test");
        }

        //// ====================================================================================

        /// <summary>
        /// Test method.
        /// </summary>
        [TestMethod]
        public void TestPrimitiveXmlTypeSerializer01()
        {
            IXmlTypeSerializer s = new XmlSerializableXmlTypeSerializer();

            Vector4f v = new Vector4f(1.0f, 2.0f, 3.0f, 4.0f);
            string name;
            object value;

            XElement x = s.Serialize("test", v);
            s.Deserialize(x, out name, out value);

            Assert.AreEqual<Vector4f>((Vector4f)value, new Vector4f(1.0f, 2.0f, 3.0f, 4.0f));
            Assert.AreEqual(name, "test");
        }
    }
}
