﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using EffectMaker.Foundation.Extensions;
using EffectMaker.Foundation.Primitives;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Layout;
using EffectMaker.UIControls.Specifics.Sliders;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.EffectMaker.UIControls.TestTypes;

namespace Test.EffectMaker.UIControls.UnitTests
{
    /// <summary>
    /// Test class for Sliders.
    /// </summary>
    [TestClass]
    public class SliderUnitTests
    {
        /// <summary>
        /// Try to simply create an instance of the UISlider.
        /// </summary>
        [TestMethod]
        public void TestSliderInstancing01()
        {
            var slider = new UISlider();
            Assert.IsNull(slider.Primitive, "Failed");
        }

        /// <summary>
        /// Try to set a primitive (IPrimitive) to the slider.
        /// </summary>
        [TestMethod]
        public void TestSetPrimitive01()
        {
            var slider = new UISlider();

            bool error = false;
            try
            {
                slider.Primitive = new TestPrimitive();
                error = true;
            }
            catch
            {
            }

            Assert.IsFalse(error, "Failed");
        }

        /// <summary>
        /// Try to set a generic primitive (IPrimitive) to the slider.
        /// </summary>
        [TestMethod]
        public void TestSetPrimitive02()
        {
            var slider = new UISlider();

            bool error = false;
            try
            {
                slider.Primitive = new TestGenericPrimitive<double>();
                error = true;
            }
            catch
            {
            }

            Assert.IsFalse(error, "Failed");
        }

        /// <summary>
        /// Try to set a primitive (PrimitiveBase(T)) to the slider.
        /// </summary>
        [TestMethod]
        public void TestSetPrimitive03()
        {
            var slider = new UISlider();
            var primitive = new TestPrimitiveBase();
            primitive[0] = 1;

            slider.Primitive = primitive;

            Assert.AreEqual(slider.Controls.Count, 1, "Invalid control count");

            var trackBarPanel = (StackPanel)slider.Controls[0];
            var trk = (UIDialSlider)trackBarPanel.Controls[0];

            Assert.AreEqual(trk.Value, 1, "Invalid control setup");

            primitive[0] = 3;
            slider.Primitive = primitive;

            Assert.AreEqual(trk.Value, 3, "Invalid control update");

            trk.Value = 18;

            // must test slider.Primitive[0] and not primitive[0] because it has been cloned
            Assert.AreEqual(slider.Primitive[0], 18, "Invalid primitive update");
        }
    }
}
