﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.Foundation.Utility;
using EffectMaker.UIControls;
using EffectMaker.UIControls.Xaml;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.EffectMaker.UIControls.TestTypes;

namespace Test.EffectMaker.UIControls.UnitTests
{
    /// <summary>
    /// Unit test class related to control resources.
    /// </summary>
    [TestClass]
    public class ResourcesUnitTests
    {
        /// <summary>
        /// Test creation and access of a resources declared in XAML.
        /// </summary>
        [TestMethod]
        public void Test01()
        {
            var control = this.LoadControl("test_resources.xaml");
            Assert.IsNotNull(control);

            var ctrl = control as IControl;
            Assert.IsNotNull(ctrl);

            Assert.AreEqual(ctrl.Resources.Count, 2);

            Assert.IsInstanceOfType(ctrl.Resources["r1"], typeof(BooleanViewModel));
        }

        /// <summary>
        /// Test creation and access of a resources declared in XAML.
        /// </summary>
        [TestMethod]
        public void Test02()
        {
            var control = this.LoadControl("test_resources.xaml");
            Assert.IsNotNull(control);

            var ctrl = control as IControl;
            Assert.IsNotNull(ctrl);

            Assert.IsInstanceOfType(
                ctrl.Resources["StringToBooleanValueConverter"],
                typeof(StringToBooleanValueConverter));
        }

        /// <summary>
        /// Loads a control from a XAML file using a name relative to the executable directory.
        /// </summary>
        /// <param name="relativeResourceName">Relative XAML resource name.</param>
        /// <returns>Returns a control, or throws an exception.</returns>
        private Control LoadControl(string relativeResourceName)
        {
            Control control;

            var assembly = Assembly.GetExecutingAssembly();

            using (Stream stream = ResourceUtility.LoadEmbedded(assembly, relativeResourceName))
            {
                control = XamlLoader.Load(stream);
            }

            return control;
        }
    }
}
