﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Xml.Schema;
using EffectMaker.Foundation.Core;
using EffectMaker.Foundation.Interfaces;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// Class implementing the IPrimitive interface, for test purpose only.
    /// </summary>
    public class TestPrimitive : IPrimitive
    {
        /// <summary>
        /// Backing field for the Value property.
        /// </summary>
        private int value;

        /// <summary>
        /// Gets the number of components in the primitive.
        /// </summary>
        public int Count
        {
            get { return 1; }
        }

        /// <summary>
        /// Gets the type on the components.
        /// </summary>
        public ValueTypes ValueType
        {
            get { return ValueTypes.Int; }
        }

        /// <summary>
        /// Gets or sets the value at a certain index.
        /// </summary>
        /// <param name="index">The index.</param>
        /// <returns>The value.</returns>
        object IPrimitive.this[int index]
        {
            get
            {
                if (index != 0)
                {
                    throw new IndexOutOfRangeException();
                }

                return this.value;
            }

            set
            {
                if (index != 0)
                {
                    throw new IndexOutOfRangeException();
                }

                this.value = (int)value;
            }
        }

        /// <summary>
        /// Set to zero.
        /// </summary>
        public void SetZero()
        {
            this.value = 0;
        }

        /// <summary>
        /// Set to one.
        /// </summary>
        public void SetOne()
        {
            this.value = 1;
        }

        /// <summary>
        /// Not implemented.
        /// </summary>
        /// <returns>Never returns, throws a NotImplementedException exception.</returns>
        public XmlSchema GetSchema()
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// Not implemented.
        /// </summary>
        /// <param name="reader">An XML reader to read data from.</param>
        public void ReadXml(XmlReader reader)
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// Not implemented.
        /// </summary>
        /// <param name="writer">An XML writer to write data to.</param>
        public void WriteXml(XmlWriter writer)
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// Creates a duplicated instance of the current one.
        /// </summary>
        /// <returns>Returns a cloned instance of the current one.</returns>
        public object Clone()
        {
            return new TestPrimitive { value = this.value };
        }

        /// <summary>
        /// Set new component values.
        /// </summary>
        /// <param name="src">New component values.</param>
        /// <returns>Returns true if components could be set, false otherwise.</returns>
        public bool Set(object src)
        {
            if ((src is int) == false)
            {
                return false;
            }

            this.value = (int)src;

            return true;
        }
    }
}
