﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <nw/dev.h>
#include <nw/eft2.h>


//---------------------------------------------------
//  カスタムアクション
//---------------------------------------------------
class CustomActionTest
{
public:
    //------------------------------------------------------------------------------
    //  初期化
    //------------------------------------------------------------------------------
    static void Initialize( nw::eft2::System* system )
    {
        nw::eft2::CallbackSet set;
        set.particleCalc = _ParticleEmitCallback;
        system->SetCallback( nw::eft2::EFT_CUSTOM_ACTION_CALLBACK_ID_2, set );
    }

    //------------------------------------------------------------------------------
    //  パーティクル生成後コールバック
    //------------------------------------------------------------------------------
    static void _ParticleEmitCallback( nw::eft2::ParticleCalcArg& arg )
    {
        using namespace nw::eft2;

        ResCustomActionData* param = arg.emitter->GetCustomActionParameter();
        nw::math::VEC3 worldPos;
        arg.GetWorldPos( &worldPos );

        f32 layerY[3];
        for( u32 i = 0; i<3; ++i )
        {
            layerY[i] = param->fValue[i];
        }

        {
            nw::math::VEC3 localPos;
            arg.GetLocalPos( &localPos );
            arg.SetLocalPos( localPos );
        }

        if( worldPos.y <= layerY[0] )
        {
            // 何もしない
            nw::math::VEC3 vec;
            arg.GetLocalVec( &vec );
        }
        else if( layerY[0] < worldPos.y && worldPos.y <= layerY[1] )
        {
            // 速度Xは常に正
            nw::math::VEC3 vec;
            arg.GetLocalVec( &vec );
            if( vec.x < 0 )
            {
                vec.x = -vec.x;
            }
            arg.SetLocalVec( vec );
        }
        else if( layerY[1] < worldPos.y && worldPos.y <= layerY[2] )
        {
            // 速度Zは常に正
            nw::math::VEC3 vec;
            arg.GetLocalVec( &vec );
            if( vec.z < 0 )
            {
                vec.z = -vec.z;
            }
            arg.SetLocalVec( vec );
        }
        else
        {
            // 速度Yを反転。Y座標を位置をlayer[2]に戻す。
            nw::math::VEC3 vec;
            arg.GetLocalVec( &vec );
            if( vec.y > 0 )
            {
                vec.y = -vec.y;
            }
            arg.SetLocalVec( vec );

            worldPos.y = layerY[2];
            arg.SetWorldPos( worldPos );
        }

        // スケールはY座標に依存。
        nw::math::VEC3 scale;
        arg.GetInitScale( &scale );
        scale.y = ( worldPos.y / 10.0f ) + 1.0f;
        arg.SetInitScale( scale );
    }
};
