﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/types.h>
#include <eftdemo_FrameBuffer.h>
#include <eftdemo_Light.h>
#include <eftdemo_Texture.h>

#include <nw/dev/dev_PrimitiveRenderer.h>

namespace nw {
namespace eftdemo {


//---------------------------------------------------------------------------
//! @brief        基底クラスです。
//---------------------------------------------------------------------------
class BackGround
{
public:
    //---------------------------------------------------------------------------
    //! @brief        上位描画メソッドです。
    //---------------------------------------------------------------------------
    virtual void ProcDraw( DrawParam& param )
    {
        NW_UNUSED_VARIABLE( param );
    }
};


//---------------------------------------------------------------------------
//! @brief        標準背景クラスです。
//---------------------------------------------------------------------------
class DefaultBackground : public BackGround
{
public:
    //---------------------------------------------------------------------------
    //! @brief        標準背景描画メソッドです。
    //---------------------------------------------------------------------------
    void ProcDraw( DrawParam& drawParam )
    {
        u32 cnt = 0;

        nw::gfnd::Graphics* graphics = nw::gfnd::Graphics::GetInstance();
        graphics->SetBlendEnable(false);
        graphics->SetBlendFactor( nw::gfnd::Graphics::BLEND_FACTOR_SRC_ALPHA, nw::gfnd::Graphics::BLEND_FACTOR_INV_SRC_ALPHA );


        {
            drawParam.mPrimitiveRenderer->SetProjectionMtx( &drawParam.mProjMtx );
            drawParam.mPrimitiveRenderer->SetViewMtx( &drawParam.mViewMtx );

            drawParam.mPrimitiveRenderer->Begin();
            {
                graphics->SetDepthTestEnable( true );
                graphics->SetDepthWriteEnable( true );
                graphics->SetDepthFunc( nw::gfnd::Graphics::DEPTH_FUNC_LESS_EQUAL );
                graphics->SetStencilTestEnable( false );

                {
                    nw::dev::PrimitiveRenderer::CubeArg arg;

                    for ( s32 i = -5; i < 5; i++ )
                    {
                        for ( s32 j = -5; j < 5; j++ )
                        {
                            arg.SetCenter( i * 10.f + 5.f, 0.0f, j * 10.f + 5.f );
                            arg.SetSize( 10.f, 0.1f, 10.f);

                            if ( cnt % 2 == 0 )
                            {
                                arg.SetColor( nw::ut::Color4u8( 64, 64, 64, 255 ), nw::ut::Color4u8( 64, 64, 64, 255 ) );
                            }
                            else
                            {
                                arg.SetColor( nw::ut::Color4u8( 32, 32, 32, 255 ), nw::ut::Color4u8( 32, 32, 32, 255 ) );
                            }
                            drawParam.mPrimitiveRenderer->DrawCube( arg );
                            cnt++;
                        }
                        cnt++;
                    }
                }
            }
            drawParam.mPrimitiveRenderer->End();
        }
    }
};


//---------------------------------------------------------------------------
//! @brief        標準グリッド描画クラスです。
//---------------------------------------------------------------------------
class DefaultGrid : public BackGround
{
public:
    //---------------------------------------------------------------------------
    //! @brief        標準グリッド描画メソッドです。
    //---------------------------------------------------------------------------
    void ProcDraw( DrawParam& drawParam )
    {
        nw::gfnd::Graphics* graphics = nw::gfnd::Graphics::GetInstance();
        graphics->SetBlendEnable(false);
        graphics->SetDepthTestEnable( false );

        {
            drawParam.mPrimitiveRenderer->SetProjectionMtx( &drawParam.mProjMtx );
            drawParam.mPrimitiveRenderer->SetViewMtx( &drawParam.mViewMtx );
            drawParam.mPrimitiveRenderer->SetModelMatrix( nw::math::MTX34::Identity() );

            drawParam.mPrimitiveRenderer->Begin();
            {
                graphics->SetDepthTestEnable( true );
                graphics->SetDepthWriteEnable( true );

                {
                    nw::ut::Color4u8 color( 0xff, 0xff, 0xff, 0xff );
                    nw::ut::Color4u8 red( 0xff, 0x00, 0x00, 0xff );
                    nw::ut::Color4u8 blue( 0x00, 0x00, 0xff, 0xff );
                    nw::ut::Color4u8 green( 0x00, 0xff, 0x00, 0xff );

                    f32 interval = -50;
                    for (int i = 0; i < 11; i++)
                    {
                        {
                            drawParam.mPrimitiveRenderer->DrawLine(nw::math::VEC3(-50.f, 0.f, interval), nw::math::VEC3(50.f, 0.f, interval), color);
                            drawParam.mPrimitiveRenderer->DrawLine(nw::math::VEC3(interval, 0.f, -50.f), nw::math::VEC3(interval, 0.f, 50.f), color);
                        }
                        interval += 10;
                    }

                    drawParam.mPrimitiveRenderer->DrawLine(nw::math::VEC3(0.0f, 0.0f, 0.0f), nw::math::VEC3(10.0f,  0.0f,  0.0f), red, 4.0f );
                    drawParam.mPrimitiveRenderer->DrawLine(nw::math::VEC3(0.0f, 0.0f, 0.0f), nw::math::VEC3( 0.0f,  0.0f, 10.0f), blue, 4.0f );
                    drawParam.mPrimitiveRenderer->DrawLine(nw::math::VEC3(0.0f, 0.0f, 0.0f), nw::math::VEC3( 0.0f, 10.f,   0.0f), green, 4.0f );
                }
            }
            drawParam.mPrimitiveRenderer->End();
        }
    }
};


//---------------------------------------------------------------------------
//! @brief          高詳細グリッド描画クラスです。
//---------------------------------------------------------------------------
class HighGrid : public BackGround
{
public:
    //---------------------------------------------------------------------------
    //! @brief        標準グリッド描画メソッドです。
    //---------------------------------------------------------------------------
    void ProcDraw( DrawParam& drawParam )
    {
        nw::gfnd::Graphics* graphics = nw::gfnd::Graphics::GetInstance();
        graphics->SetBlendEnable(false);
        graphics->SetDepthTestEnable( false );

        {
            drawParam.mPrimitiveRenderer->SetProjectionMtx( &drawParam.mProjMtx );
            drawParam.mPrimitiveRenderer->SetViewMtx( &drawParam.mViewMtx );

            drawParam.mPrimitiveRenderer->Begin();
            {
                graphics->SetDepthTestEnable( true );
                graphics->SetDepthWriteEnable( true );

                {
                    nw::ut::Color4u8 color( 0xff, 0xff, 0xff, 0xff );
                    nw::ut::Color4u8 red( 0xff, 0x00, 0x00, 0xff );
                    nw::ut::Color4u8 blue( 0x00, 0x00, 0xff, 0xff );
                    nw::ut::Color4u8 green( 0x00, 0xff, 0x00, 0xff );

                    f32 interval = -50;
                    for (int i = 0; i < 101; i++)
                    {
                        {
                            drawParam.mPrimitiveRenderer->DrawLine(nw::math::VEC3(-50.f, 0.f, interval), nw::math::VEC3(50.f, 0.f, interval), color);
                            drawParam.mPrimitiveRenderer->DrawLine(nw::math::VEC3(interval, 0.f, -50.f), nw::math::VEC3(interval, 0.f, 50.f), color);
                        }
                        interval += 1;
                    }

                    drawParam.mPrimitiveRenderer->DrawLine(nw::math::VEC3(0.0f, 0.0f, 0.0f), nw::math::VEC3(10.0f,  0.0f,  0.0f), red, 4.0f );
                    drawParam.mPrimitiveRenderer->DrawLine(nw::math::VEC3(0.0f, 0.0f, 0.0f), nw::math::VEC3( 0.0f,  0.0f, 10.0f), blue, 4.0f );
                    drawParam.mPrimitiveRenderer->DrawLine(nw::math::VEC3(0.0f, 0.0f, 0.0f), nw::math::VEC3( 0.0f, 10.f,   0.0f), green, 4.0f );
                }
            }
            drawParam.mPrimitiveRenderer->End();
        }
    }
};


} // namespace eftdemo
} // namespace nw
