﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConverterTestApp
{
    /// <summary>
    /// バイナリ比較テストクラス
    /// </summary>
    internal class BinaryTest
    {
        /// <summary>
        /// バイナリチェック
        /// </summary>
        /// <param name="binPath1">バイナリファイルパス1</param>
        /// <param name="binPath2">バイナリファイルパス2</param>
        public bool CompareBinary(string binPath1, string binPath2)
        {
            if (!Utility.CheckFile(binPath1) || !Utility.CheckFile(binPath2))
            {
                return false;
            }

            var file1 = new FileInfo(binPath1);
            var file2 = new FileInfo(binPath2);
            if (file1.Length != file2.Length)
            {
                return false;
            }

            // バイナリファイルの読み込み
            var stream1 = File.Open(binPath1, System.IO.FileMode.Open, System.IO.FileAccess.Read);
            var stream2 = File.Open(binPath2, System.IO.FileMode.Open, System.IO.FileAccess.Read);
            var binReader1 = new BinaryReader(stream1);
            var binReader2 = new BinaryReader(stream2);

            var dif = true;

            // 比較処理
            while (true)
            {
                var bytDt1 = stream1.ReadByte();
                var bytDt2 = stream2.ReadByte();

                // バイナリデータを比較
                if (bytDt1 != bytDt2)
                {
                    dif = false;
                    break;
                }

                if (bytDt1 == -1)
                {
                    break;
                }
            }

            binReader1.Close();
            binReader2.Close();
            stream1.Close();
            stream2.Close();

            return dif;
        }
    }
}
