﻿using System;
using System.Threading;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Web.Script.Serialization;
using DevMenuCommandTest;

namespace DevMenuCommandTestNuiShell
{

    [TestClass]
    public class TestFactoryReset : TestBase
    {
        public override void DoCleanup()
        {
            var command = new DevMenuCommandSystem(this.TestContext);
            command.Execute(new string[] {
                "debug disable-force-maintenance-mode",
                "sdcard format",
            });

            command.ResetAndExecute(new string[] {
                "application uninstall --all",
            });
        }

        [TestMethod]
        [Timeout(300 * 1000)]
        public void TestFactoryResetBase()
        {
            var maker = new MakeTestApplication(this.TestContext);
            var app = maker.MakeApplication(0x0100394000059000);

            var command = new DevMenuCommandSystem(this.TestContext);
            command.SetVerbose(true);

            Assert.IsTrue(command.Execute(new string[] {
                    "application uninstall --all",
                    "application install " + app.Path + " --measure",
                    "application list-record " + app.Id,
                    "factoryreset do",
            }));

            Assert.IsFalse(command.ResetAndExecute(new string[] {
                    "application list-record " + app.Id,
            }));

            // TODO 上記と同じアプリを使うと何故か NotFound になることがある
            //      問題のワークアラウンド
            var appAfterReset = maker.MakeApplication(0x0100394000059001);
            // TODO セーブデータの検証
            Assert.IsTrue(command.Execute(new string[] {
                "application uninstall --all",
                "application install " + appAfterReset.Path,
                "application list-record " + appAfterReset.Id,
                "factoryreset do-without-usersavedata",
            }));

            Assert.IsFalse(command.ResetAndExecute(new string[] {
                "application list-record " + appAfterReset.Id,
            }));

            maker.Cleanup();
        }

        [TestMethod]
        [Timeout(300 * 1000)]
        public void FactoryResetWithoutUser()
        {
            var command = new DevMenuCommandSystem(this.TestContext);

            ulong builtinAppId = 0x0100394000059000;
            ulong sdcardAppId = 0x010039400005a000;
            var builtInApp = m_Maker.MakeApplication(builtinAppId, 0);
            var sdcardApp = m_Maker.MakeApplication(sdcardAppId, 0);

            // ログが出てしまうので、コマンドを分ける
            Assert.IsTrue(command.Execute(new string[] {
                "application install " + builtInApp.Path,
                "application install -s sdcard " + sdcardApp.Path,
            }));
            Assert.IsTrue(command.Execute(new string[] {
                "application create-place-holder -s sdcard",
                "application create-place-holder -s sdcard",
                "application create-place-holder",
                "application create-place-holder",
                "application list-place-holder",
            }));

            var placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count > 0);
            Assert.IsTrue(command.Execute(new string[] {
                "application list-place-holder -s sdcard",
            }));
            placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count > 0);

            Assert.IsTrue(command.Execute(new string[] {
                "application list-content-storage",
            }));
            var contentStorageList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(contentStorageList.Count > 0);

            Assert.IsTrue(command.Execute(new string[] {
                "application list-content-storage -s sdcard",
            }));
            contentStorageList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(contentStorageList.Count > 0);

            Assert.IsTrue(command.Execute(new string[] {
                "application list-content-meta-database",
            }));
            var contentMetaDatabaseList = new JavaScriptSerializer().Deserialize<List<ContentMetaDatabaseForJson>>(command.LastOutput);
            Assert.IsTrue(contentMetaDatabaseList.Count > 0);

            Assert.IsTrue(command.Execute(new string[] {
                "application list-content-meta-database -s sdcard",
            }));
            contentMetaDatabaseList = new JavaScriptSerializer().Deserialize<List<ContentMetaDatabaseForJson>>(command.LastOutput);
            Assert.IsTrue(contentMetaDatabaseList.Count > 0);

            Assert.IsTrue(command.Execute(new string[] {
                "debug enable-force-maintenance-mode",
            }));

            Reboot(command);

            Assert.IsTrue(command.Execute(new string[] {
                "factoryreset do-without-usersavedata",
                "debug disable-force-maintenance-mode",
            }));

            Reboot(command);

            Assert.IsTrue(command.Execute(new string[] {
                "application list-place-holder",
            }));
            placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count == 0);

            Assert.IsTrue(command.Execute(new string[] {
                "sdcard status",
            },
                TestSdCard.MsgNoOwnerShip
            ));

            Assert.IsTrue(command.Execute(new string[] {
                "application list-content-storage",
            }));
            contentStorageList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(contentStorageList.Count == 0);

            Assert.IsTrue(command.Execute(new string[] {
                "application list-content-meta-database",
            }));
            contentMetaDatabaseList = new JavaScriptSerializer().Deserialize<List<ContentMetaDatabaseForJson>>(command.LastOutput);
            Assert.IsTrue(contentMetaDatabaseList.Count == 0);
        }
    }
}
