﻿using System;
using DevMenuCommandTest;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace DevMenuCommandTestNuiShell
{
    [TestClass]
    public class TestApplicationRecord : TestBase
    {
        public override void DoCleanup()
        {
            var command = new DevMenuCommandSystem(this.TestContext);

            command.Execute(new string[] {
                "gamecard erase",
                "sdcard format",
                "debug enable-mount-sdcard",
            });
            command.ResetAndExecute(new string[] {
                "application uninstall --all",
                "application reset-required-version --all",
            });
        }

        [TestMethod]
        [Timeout(300 * 1000)]
        public void TestDifferentStorageFromApplicationRecord()
        {
            var command = new DevMenuCommandSystem(this.TestContext);

            ulong id = 0x0100394000059000;
            var appv0 = m_Maker.MakeApplication(id, 0);
            var aocv0 = m_Maker.MakeAddOnContent(id, 1, 0);
            var patchv1 = m_Maker.MakePatch(id, 1, appv0.Path);

            Assert.IsTrue(command.Execute(new string[] {
                "application install -s sdcard " + appv0.Path,
                "addoncontent install -s sdcard " + aocv0.Path,
                "patch install -s sdcard " + patchv1.Path,

                string.Format("application check-launch-version 0x{0:x16}", id),
                string.Format("application check-launch-rights 0x{0:x16}", id),
                string.Format("application launch 0x{0:x16}", id),
                "debug disable-mount-sdcard",
            }));

            Assert.IsTrue(command.ResetAndExecute(new string[] {
                "application install " + appv0.Path + " --force",
                "addoncontent install " + aocv0.Path + " --force",
                "patch install " + patchv1.Path + " --force",
                "debug enable-mount-sdcard",
            }));

            // アプリケーション記録には NAND のストレージが記載されているが、実際には SD カードに入っている
            // Reset することで、 NAND に入っている重複するコンテンツは消えているはず
            Assert.IsTrue(command.ResetAndExecute(new string[] {
                string.Format("application check-launch-version 0x{0:x16}", id),
                string.Format("application check-launch-rights 0x{0:x16}", id),
                string.Format("application launch 0x{0:x16}", id),
                string.Format("application verify 0x{0:x16}", id),
            }));
        }
    }
}
