﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using CodingCheckerUtil;
using System;
using System.IO;
using System.Text;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace GitHookTest
{
    [TestClass]
    public class PreCommitTargetExtensionTest
    {
        public TestContext TestContext { get; set; }
        private GitHookTestContext m_GitHookTestContext { get; set; }
        private const string JIRA_KEY = "SIGLO-0";

        [TestInitialize]
        public void Initialize()
        {
            m_GitHookTestContext = new GitHookTestContext(TestContext);
        }

        [TestCleanup]
        public void CleanUp()
        {
            m_GitHookTestContext.Dispose();
        }

        [TestMethod]
        public void CheckedCommitTest()
        {
            // コード規約チェック対象のファイルを生成してコミット
            string testFile = Path.Combine(m_GitHookTestContext.TestLocalRepositoryDirectory, "test.cpp");
            File.WriteAllText(testFile, "test.   ", new UTF8Encoding(true));
            m_GitHookTestContext.ExecuteGit($"add \"{testFile}\"");
            m_GitHookTestContext.ExecuteGit($"commit -m \"({JIRA_KEY}) test\"");
        }

        [TestMethod]
        public void NoCheckedCommitTest()
        {
            // コード規約チェック対象外のファイルを生成してコミット
            string testFile = Path.Combine(m_GitHookTestContext.TestLocalRepositoryDirectory, "test.bin");
            File.WriteAllBytes(testFile, new byte[] { 0x1, 0x2, 0x3, 0x4 });
            m_GitHookTestContext.ExecuteGit($"add \"{testFile}\"");
            m_GitHookTestContext.ExecuteGit($"commit -m \"({JIRA_KEY}) test\"");
        }
    }
}
